"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.putSloSettings = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _slo_settings = require("../../services/slo_settings");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const putSloSettings = isServerless => (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'PUT /internal/slo/settings',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_write']
    }
  },
  params: isServerless ? _sloSchema.putSLOServerlessSettingsParamsSchema : _sloSchema.putSLOSettingsParamsSchema,
  handler: async ({
    request,
    logger,
    params,
    plugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      soClient
    } = await getScopedClients({
      request,
      logger
    });
    return await (0, _slo_settings.storeSloSettings)(soClient, params.body);
  }
});
exports.putSloSettings = putSloSettings;