"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSLORoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _services = require("../../services");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSLORoute = exports.deleteSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'DELETE /api/observability/slos/{id} 2023-10-31',
  options: {
    access: 'public'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_write']
    }
  },
  params: _sloSchema.deleteSLOParamsSchema,
  handler: async ({
    response,
    params,
    logger,
    request,
    plugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      scopedClusterClient,
      repository,
      transformManager,
      summaryTransformManager,
      rulesClient
    } = await getScopedClients({
      request,
      logger
    });
    const deleteSLO = new _services.DeleteSLO(repository, transformManager, summaryTransformManager, scopedClusterClient, rulesClient);
    await deleteSLO.execute(params.path.id);
    return response.noContent();
  }
});