"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/alerting-plugin/common");
var _server = require("@kbn/core/server");
var _i18n = require("@kbn/i18n");
var _common2 = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
var _lockManager = require("@kbn/lock-manager");
var _client = require("./client");
var _register = require("./lib/collectors/register");
var _register_burn_rate_rule = require("./lib/rules/register_burn_rate_rule");
var _get_slo_server_route_repository = require("./routes/get_slo_server_route_repository");
var _register_routes = require("./routes/register_routes");
var _saved_objects = require("./saved_objects");
var _slo_settings = require("./saved_objects/slo_settings");
var _services = require("./services");
var _summary_transform_generator = require("./services/summary_transform_generator/summary_transform_generator");
var _bulk_delete_task = require("./services/tasks/bulk_delete/bulk_delete_task");
var _orphan_summary_cleanup_task = require("./services/tasks/orphan_summary_cleanup_task");
var _temp_summary_cleanup_task = require("./services/tasks/temp_summary_cleanup_task");
var _transform_generators = require("./services/transform_generators");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sloRuleTypes = [_ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID];
class SLOPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "isServerless", void 0);
    (0, _defineProperty2.default)(this, "isDev", void 0);
    (0, _defineProperty2.default)(this, "sloOrphanCleanupTask", void 0);
    (0, _defineProperty2.default)(this, "tempSummaryCleanupTask", void 0);
    this.initContext = initContext;
    this.logger = this.initContext.logger.get();
    this.config = this.initContext.config.get();
    this.isServerless = this.initContext.env.packageInfo.buildFlavor === 'serverless';
    this.isDev = this.initContext.env.mode.dev;
  }
  setup(core, plugins) {
    const lockManager = new _lockManager.LockManagerService(core, this.logger);
    const alertsLocator = plugins.share.url.locators.create(new _common2.AlertsLocatorDefinition());
    const savedObjectTypes = [_saved_objects.SO_SLO_TYPE, _slo_settings.SO_SLO_SETTINGS_TYPE];
    const alertingFeatures = sloRuleTypes.map(ruleTypeId => ({
      ruleTypeId,
      consumers: [_common2.sloFeatureId, _common.ALERTING_FEATURE_ID, ..._ruleDataUtils.DEPRECATED_ALERTING_CONSUMERS]
    }));
    plugins.features.registerKibanaFeature({
      id: _common2.sloFeatureId,
      name: _i18n.i18n.translate('xpack.slo.featureRegistry.linkSloTitle', {
        defaultMessage: 'SLOs'
      }),
      order: 1200,
      category: _server.DEFAULT_APP_CATEGORIES.observability,
      app: [_common2.sloFeatureId, 'kibana'],
      catalogue: [_common2.sloFeatureId, 'observability'],
      alerting: alertingFeatures,
      privileges: {
        all: {
          app: [_common2.sloFeatureId, 'kibana'],
          catalogue: [_common2.sloFeatureId, 'observability'],
          api: ['slo_write', 'slo_read', 'rac'],
          savedObject: {
            all: savedObjectTypes,
            read: []
          },
          alerting: {
            rule: {
              all: alertingFeatures
            },
            alert: {
              all: alertingFeatures
            }
          },
          ui: ['read', 'write']
        },
        read: {
          app: [_common2.sloFeatureId, 'kibana'],
          catalogue: [_common2.sloFeatureId, 'observability'],
          api: ['slo_read', 'rac'],
          savedObject: {
            all: [],
            read: savedObjectTypes
          },
          alerting: {
            rule: {
              read: alertingFeatures
            },
            alert: {
              read: alertingFeatures
            }
          },
          ui: ['read']
        }
      }
    });
    const {
      ruleDataService
    } = plugins.ruleRegistry;
    core.savedObjects.registerType(_saved_objects.slo);
    core.savedObjects.registerType(_slo_settings.sloSettings);
    (0, _register_burn_rate_rule.registerBurnRateRule)(plugins.alerting, core.http.basePath, this.logger, ruleDataService, {
      alertsLocator
    });
    (0, _register.registerSloUsageCollector)(plugins.usageCollection);
    const mappedPlugins = (0, _lodash.mapValues)(plugins, (value, key) => {
      return {
        setup: value,
        start: () => core.getStartServices().then(([, pluginStart]) => {
          return pluginStart[key];
        })
      };
    });
    (0, _register_routes.registerServerRoutes)({
      core,
      dependencies: {
        corePlugins: core,
        plugins: mappedPlugins,
        config: {
          isServerless: this.isServerless
        },
        getScopedClients: async ({
          request,
          logger
        }) => {
          var _pluginsStart$spaces$, _pluginsStart$spaces;
          const [coreStart, pluginsStart] = await core.getStartServices();
          const internalSoClient = new _server.SavedObjectsClient(coreStart.savedObjects.createInternalRepository());
          const soClient = coreStart.savedObjects.getScopedClient(request);
          const scopedClusterClient = coreStart.elasticsearch.client.asScoped(request);
          const [dataViewsService, rulesClient, {
            id: spaceId
          }, racClient] = await Promise.all([pluginsStart.dataViews.dataViewsServiceFactory(soClient, scopedClusterClient.asCurrentUser), pluginsStart.alerting.getRulesClientWithRequest(request), (_pluginsStart$spaces$ = (_pluginsStart$spaces = pluginsStart.spaces) === null || _pluginsStart$spaces === void 0 ? void 0 : _pluginsStart$spaces.spacesService.getActiveSpace(request)) !== null && _pluginsStart$spaces$ !== void 0 ? _pluginsStart$spaces$ : {
            id: 'default'
          }, pluginsStart.ruleRegistry.getRacClientWithRequest(request)]);
          const repository = new _services.KibanaSavedObjectsSLORepository(soClient, logger);
          const transformManager = new _services.DefaultTransformManager((0, _transform_generators.createTransformGenerators)(spaceId, dataViewsService, this.isServerless), scopedClusterClient, logger);
          const summaryTransformManager = new _services.DefaultSummaryTransformManager(new _summary_transform_generator.DefaultSummaryTransformGenerator(), scopedClusterClient, logger);
          return {
            scopedClusterClient,
            soClient,
            internalSoClient,
            dataViewsService,
            rulesClient,
            spaceId,
            repository,
            transformManager,
            summaryTransformManager,
            racClient
          };
        }
      },
      logger: this.logger,
      repository: (0, _get_slo_server_route_repository.getSloServerRouteRepository)({
        isServerless: this.isServerless
      }),
      isDev: this.isDev
    });
    core.getStartServices().then(async ([coreStart, pluginStart]) => {
      const esInternalClient = coreStart.elasticsearch.client.asInternalUser;
      const sloResourceInstaller = new _services.DefaultResourceInstaller(esInternalClient, this.logger);
      await lockManager.withLock(_constants.LOCK_ID_RESOURCE_INSTALLER, () => sloResourceInstaller.ensureCommonResourcesInstalled());
    }).catch(err => {
      if (err instanceof _lockManager.LockAcquisitionError) {
        this.logger.debug('Cannot install SLO resources, another process is already doing it');
      }
    });
    this.sloOrphanCleanupTask = new _orphan_summary_cleanup_task.SloOrphanSummaryCleanupTask(plugins.taskManager, this.logger, this.config);
    this.tempSummaryCleanupTask = new _temp_summary_cleanup_task.TempSummaryCleanupTask({
      core,
      taskManager: plugins.taskManager,
      logFactory: this.initContext.logger,
      config: this.config
    });
    new _bulk_delete_task.BulkDeleteTask({
      core,
      plugins: mappedPlugins,
      logFactory: this.initContext.logger
    });
    return {};
  }
  start(core, plugins) {
    var _this$sloOrphanCleanu, _this$tempSummaryClea;
    const internalSoClient = new _server.SavedObjectsClient(core.savedObjects.createInternalRepository());
    const internalEsClient = core.elasticsearch.client.asInternalUser;
    (_this$sloOrphanCleanu = this.sloOrphanCleanupTask) === null || _this$sloOrphanCleanu === void 0 ? void 0 : _this$sloOrphanCleanu.start(plugins.taskManager, internalSoClient, internalEsClient).catch(() => {});
    (_this$tempSummaryClea = this.tempSummaryCleanupTask) === null || _this$tempSummaryClea === void 0 ? void 0 : _this$tempSummaryClea.start(plugins).catch(() => {});
    return {
      getSloClientWithRequest: request => {
        return (0, _client.getSloClientWithRequest)({
          request,
          soClient: core.savedObjects.getScopedClient(request),
          esClient: internalEsClient
        });
      }
    };
  }
}
exports.SLOPlugin = SLOPlugin;