"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetcher = void 0;
var _esQuery = require("@kbn/es-query");
var _sloSchema = require("@kbn/slo-schema");
var _saved_objects = require("../../saved_objects");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetcher = async context => {
  var _totalInstances$count;
  const finder = context.soClient.createPointInTimeFinder({
    type: _saved_objects.SO_SLO_TYPE,
    perPage: 100
  });
  const totalInstances = await context.esClient.count({
    index: _constants.SUMMARY_DESTINATION_INDEX_PATTERN,
    query: {
      bool: {
        filter: [{
          term: {
            isTempDoc: false
          }
        }]
      }
    }
  });
  let usage = {
    total: 0,
    definitions: {
      total: 0,
      total_with_ccs: 0,
      total_with_groups: 0
    },
    instances: {
      total: (_totalInstances$count = totalInstances === null || totalInstances === void 0 ? void 0 : totalInstances.count) !== null && _totalInstances$count !== void 0 ? _totalInstances$count : 0
    },
    by_status: {
      enabled: 0,
      disabled: 0
    },
    by_sli_type: {},
    by_rolling_duration: {},
    by_calendar_aligned_duration: {},
    by_budgeting_method: {
      occurrences: 0,
      timeslices: 0
    }
  };
  for await (const response of finder.find()) {
    usage = response.saved_objects.reduce((acc, so) => {
      var _acc$by_sli_type$so$a, _acc$by_rolling_durat, _acc$by_calendar_alig;
      return {
        ...acc,
        total: acc.total + 1,
        // deprecated in favor of definitions.total
        definitions: {
          total: acc.definitions.total + 1,
          total_with_ccs: (0, _esQuery.isCCSRemoteIndexName)(so.attributes.indicator.params.index) ? acc.definitions.total_with_ccs + 1 : acc.definitions.total_with_ccs,
          total_with_groups: [so.attributes.groupBy].flat().includes(_sloSchema.ALL_VALUE) ? acc.definitions.total_with_groups : acc.definitions.total_with_groups + 1
        },
        by_status: {
          ...acc.by_status,
          ...(so.attributes.enabled && {
            enabled: acc.by_status.enabled + 1
          }),
          ...(!so.attributes.enabled && {
            disabled: acc.by_status.disabled + 1
          })
        },
        by_sli_type: {
          ...acc.by_sli_type,
          [so.attributes.indicator.type]: ((_acc$by_sli_type$so$a = acc.by_sli_type[so.attributes.indicator.type]) !== null && _acc$by_sli_type$so$a !== void 0 ? _acc$by_sli_type$so$a : 0) + 1
        },
        by_rolling_duration: {
          ...acc.by_rolling_duration,
          ...(so.attributes.timeWindow.type === 'rolling' && {
            [so.attributes.timeWindow.duration]: ((_acc$by_rolling_durat = acc.by_rolling_duration[so.attributes.timeWindow.duration]) !== null && _acc$by_rolling_durat !== void 0 ? _acc$by_rolling_durat : 0) + 1
          })
        },
        by_calendar_aligned_duration: {
          ...acc.by_calendar_aligned_duration,
          ...(so.attributes.timeWindow.type === 'calendarAligned' && {
            [so.attributes.timeWindow.duration]: ((_acc$by_calendar_alig = acc.by_calendar_aligned_duration[so.attributes.timeWindow.duration]) !== null && _acc$by_calendar_alig !== void 0 ? _acc$by_calendar_alig : 0) + 1
          })
        },
        by_budgeting_method: {
          ...acc.by_budgeting_method,
          ...(so.attributes.budgetingMethod === 'occurrences' && {
            occurrences: acc.by_budgeting_method.occurrences + 1
          }),
          ...(so.attributes.budgetingMethod === 'timeslices' && {
            timeslices: acc.by_budgeting_method.timeslices + 1
          })
        }
      };
    }, usage);
  }
  await finder.close();
  return {
    slo: usage
  };
};
exports.fetcher = fetcher;