"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toCalendarAlignedTimeWindowMomentUnit = toCalendarAlignedTimeWindowMomentUnit;
exports.toRollingTimeWindowMomentUnit = toRollingTimeWindowMomentUnit;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toCalendarAlignedTimeWindowMomentUnit(timeWindow) {
  const unit = timeWindow.duration.unit;
  switch (unit) {
    case 'w':
      return 'isoWeeks';
    case 'M':
      return 'months';
    default:
      throw new Error(`Invalid calendar aligned time window duration unit: ${unit}`);
  }
}
function toRollingTimeWindowMomentUnit(timeWindow) {
  const unit = timeWindow.duration.unit;
  switch (unit) {
    case 'd':
      return 'days';
    default:
      throw new Error(`Invalid rolling time window duration unit: ${unit}`);
  }
}