"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLI_INDEX_TEMPLATE = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLI_INDEX_TEMPLATE = exports.SLI_INDEX_TEMPLATE = {
  name: _constants.SLI_INDEX_TEMPLATE_NAME,
  index_patterns: [_constants.SLI_INDEX_TEMPLATE_PATTERN],
  composed_of: [_constants.SLI_COMPONENT_TEMPLATE_MAPPINGS_NAME, _constants.SLI_COMPONENT_TEMPLATE_SETTINGS_NAME],
  priority: 500,
  _meta: {
    description: 'Template for SLO rollup data',
    version: _constants.SLO_RESOURCES_VERSION,
    managed: true,
    managed_by: 'observability'
  }
};