"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDelayInSecondsFromSLO = getDelayInSecondsFromSLO;
var _sloSchema = require("@kbn/slo-schema");
var _Either = require("fp-ts/Either");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDelayInSecondsFromSLO(slo) {
  const fixedInterval = _sloSchema.timeslicesBudgetingMethodSchema.is(slo.budgetingMethod) ? durationStringToSeconds(slo.objective.timesliceWindow) : 60;
  const syncDelay = durationStringToSeconds(slo.settings.syncDelay);
  const frequency = durationStringToSeconds(slo.settings.frequency);
  return fixedInterval + syncDelay + frequency;
}
function durationStringToSeconds(duration) {
  if (!duration) {
    return 0;
  }
  const result = _sloSchema.durationType.decode(duration);
  if ((0, _Either.isLeft)(result)) {
    throw new Error(`Invalid duration string: ${duration}`);
  }
  return result.right.asSeconds();
}