"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UngroupedView = UngroupedView;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_url_search_state = require("../../hooks/use_url_search_state");
var _slos_view = require("../slos_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/ungrouped_slos/ungrouped_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function UngroupedView({
  sloList,
  loading,
  error,
  view
}) {
  const {
    state,
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const {
    page,
    perPage
  } = state;
  const {
    results = [],
    total = 0
  } = sloList !== null && sloList !== void 0 ? sloList : {};
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_slos_view.SlosView, {
    sloList: results,
    loading: loading,
    error: error,
    view: view,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }), total > 0 && total > perPage ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    pageCount: Math.ceil(total / perPage),
    activePage: page,
    onChangePage: newPage => {
      onStateChange({
        page: newPage
      });
    },
    itemsPerPage: perPage,
    itemsPerPageOptions: [10, 25, 50, 100],
    onChangeItemsPerPage: newPerPage => {
      onStateChange({
        perPage: newPerPage,
        page: 0
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 11
    }
  })) : null);
}