"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupView = GroupView;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_slo_groups = require("../../../../hooks/use_fetch_slo_groups");
var _use_url_search_state = require("../../hooks/use_url_search_state");
var _group_list_empty = require("./group_list_empty");
var _group_list_error = require("./group_list_error");
var _group_list_view = require("./group_list_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/grouped_slos/group_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function GroupView({
  kqlQuery,
  view,
  sort,
  direction,
  groupBy,
  groupsFilter,
  filters,
  lastRefreshTime
}) {
  const {
    state,
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const {
    tagsFilter,
    statusFilter,
    page,
    perPage,
    lastRefresh
  } = state;
  const {
    data,
    isLoading,
    isError,
    isRefetching,
    refetch
  } = (0, _use_fetch_slo_groups.useFetchSloGroups)({
    perPage,
    page: page + 1,
    groupBy,
    kqlQuery,
    tagsFilter,
    statusFilter,
    filters,
    lastRefresh,
    groupsFilter
  });
  (0, _react.useEffect)(() => {
    refetch();
  }, [lastRefreshTime, refetch]);
  const {
    results = [],
    total = 0
  } = data !== null && data !== void 0 ? data : {};
  const handlePageClick = pageNumber => {
    onStateChange({
      page: pageNumber
    });
  };
  if (isLoading || isRefetching) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "sloGroupListLoading",
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 16
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    });
  }
  if (!isLoading && !isError && results.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_group_list_empty.SloGroupListEmpty, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 12
      }
    });
  }
  if (!isLoading && isError) {
    return /*#__PURE__*/_react.default.createElement(_group_list_error.SloGroupListError, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "sloGroupView",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, results && results.map(result => /*#__PURE__*/_react.default.createElement(_group_list_view.GroupListView, {
    groupBy: result.groupBy,
    key: result.group,
    view: view,
    group: result.group,
    kqlQuery: kqlQuery,
    sort: sort,
    direction: direction,
    summary: result.summary,
    filters: filters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  })), total > 0 && total > perPage ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    "data-test-subj": "sloGroupListPagination",
    pageCount: Math.ceil(total / perPage),
    activePage: page,
    onChangePage: handlePageClick,
    itemsPerPage: perPage,
    itemsPerPageOptions: [10, 25, 50, 100],
    onChangeItemsPerPage: newPerPage => {
      onStateChange({
        perPage: newPerPage,
        page: 0
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  })) : null);
}