"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloSettingsPage = SloSettingsPage;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _settings_form = require("./settings_form");
var _use_kibana = require("../../hooks/use_kibana");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _paths = require("../../../common/locators/paths");
var _header_menu = require("../../components/header_menu/header_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_settings/slo_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloSettingsPage() {
  const {
    http: {
      basePath
    },
    serverless
  } = (0, _use_kibana.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  (0, _public.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.slosSettings),
    text: _i18n.i18n.translate('xpack.slo.breadcrumbs.slosSettingsText', {
      defaultMessage: 'SLOs Settings'
    })
  }], {
    serverless
  });
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "slosSettingsPage",
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.slo.pageHeader.title.', {
        defaultMessage: 'SLOs Settings'
      }),
      rightSideItems: []
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_settings_form.SettingsForm, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }));
}