"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLO_MANAGEMENT_SEARCH_URL_STORAGE_KEY = exports.SLO_MANAGEMENT_SEARCH_SESSION_STORAGE_KEY = exports.DEFAULT_STATE = void 0;
exports.useUrlSearchState = useUrlSearchState;
var _public = require("@kbn/kibana-utils-plugin/public");
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_MANAGEMENT_SEARCH_URL_STORAGE_KEY = exports.SLO_MANAGEMENT_SEARCH_URL_STORAGE_KEY = 'search';
const SLO_MANAGEMENT_SEARCH_SESSION_STORAGE_KEY = exports.SLO_MANAGEMENT_SEARCH_SESSION_STORAGE_KEY = 'slo.management_page_search_state';
const DEFAULT_STATE = exports.DEFAULT_STATE = {
  search: '',
  tags: [],
  page: 0,
  perPage: _constants.DEFAULT_SLO_PAGE_SIZE,
  includeOutdatedOnly: false
};
function useUrlSearchState() {
  const [state, setState] = (0, _react.useState)(DEFAULT_STATE);
  const history = (0, _reactRouterDom.useHistory)();
  const urlStateStorage = (0, _react.useRef)((0, _public.createKbnUrlStateStorage)({
    history,
    useHash: false,
    useHashQuery: false
  }));
  const sessionStorage = (0, _react.useRef)((0, _public.createSessionStorageStateStorage)(window.localStorage));
  (0, _react.useEffect)(() => {
    var _urlStateStorage$curr, _ref, _urlStateStorage$curr2, _urlStateStorage$curr3, _sessionStorage$curre;
    const sub = (_urlStateStorage$curr = urlStateStorage.current) === null || _urlStateStorage$curr === void 0 ? void 0 : _urlStateStorage$curr.change$(SLO_MANAGEMENT_SEARCH_URL_STORAGE_KEY).subscribe(newSearchState => {
      if (newSearchState) {
        setState(newSearchState);
      }
    });
    setState((_ref = (_urlStateStorage$curr2 = (_urlStateStorage$curr3 = urlStateStorage.current) === null || _urlStateStorage$curr3 === void 0 ? void 0 : _urlStateStorage$curr3.get(SLO_MANAGEMENT_SEARCH_URL_STORAGE_KEY)) !== null && _urlStateStorage$curr2 !== void 0 ? _urlStateStorage$curr2 : (_sessionStorage$curre = sessionStorage.current) === null || _sessionStorage$curre === void 0 ? void 0 : _sessionStorage$curre.get(SLO_MANAGEMENT_SEARCH_SESSION_STORAGE_KEY)) !== null && _ref !== void 0 ? _ref : DEFAULT_STATE);
    return () => {
      sub === null || sub === void 0 ? void 0 : sub.unsubscribe();
    };
  }, [urlStateStorage, sessionStorage]);
  const onStateChange = (0, _react.useCallback)(newState => {
    var _urlStateStorage$curr4;
    const updatedState = {
      ...state,
      page: 0,
      ...newState
    };
    setState(() => updatedState);
    (_urlStateStorage$curr4 = urlStateStorage.current) === null || _urlStateStorage$curr4 === void 0 ? void 0 : _urlStateStorage$curr4.set(SLO_MANAGEMENT_SEARCH_URL_STORAGE_KEY, updatedState, {
      replace: true
    });
  }, [state]);
  return {
    state: (0, _deepmerge.default)(DEFAULT_STATE, state),
    onStateChange
  };
}