"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditFormDescriptionSection = SloEditFormDescriptionSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _dashboardsSelector = require("@kbn/dashboards-selector");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_fetch_suggestions = require("../hooks/use_fetch_suggestions");
var _optional_text = require("./common/optional_text");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/slo_edit_form_description_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloEditFormDescriptionSection() {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const sloNameId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'sloName'
  });
  const descriptionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'sloDescription'
  });
  const tagsId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'tags'
  });
  const {
    suggestions
  } = (0, _use_fetch_suggestions.useFetchSLOSuggestions)();
  const {
    services
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    style: {
      maxWidth: _constants.MAX_WIDTH
    },
    "data-test-subj": "sloEditFormDescriptionSection",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: getFieldState('name').invalid,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.description.sloName', {
      defaultMessage: 'SLO Name'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "name",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, field, {
      fullWidth: true,
      isInvalid: fieldState.invalid,
      id: sloNameId,
      "data-test-subj": "sloFormNameInput",
      placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.description.sloNamePlaceholder', {
        defaultMessage: 'Name for the SLO'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.description.sloDescription', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 22
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "description",
    defaultValue: "",
    control: control,
    rules: {
      required: false
    },
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({}, field, {
      fullWidth: true,
      id: descriptionId,
      "data-test-subj": "sloFormDescriptionTextArea",
      placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.description.sloDescriptionPlaceholder', {
        defaultMessage: 'A short description of the SLO'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.tags.label', {
      defaultMessage: 'Tags'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 22
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "tags",
    control: control,
    defaultValue: [],
    rules: {
      required: false
    },
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => {
      var _suggestions$tags;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
        id: tagsId,
        fullWidth: true,
        "aria-label": _i18n.i18n.translate('xpack.slo.sloEdit.tags.placeholder', {
          defaultMessage: 'Add tags'
        }),
        placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.tags.placeholder', {
          defaultMessage: 'Add tags'
        }),
        isInvalid: fieldState.invalid,
        options: (_suggestions$tags = suggestions === null || suggestions === void 0 ? void 0 : suggestions.tags) !== null && _suggestions$tags !== void 0 ? _suggestions$tags : [],
        selectedOptions: generateTagOptions(field.value),
        onChange: selected => {
          if (selected.length) {
            return field.onChange(selected.map(opts => opts.value));
          }
          field.onChange([]);
        },
        onCreateOption: (searchValue, options = []) => {
          var _field$value;
          const normalizedSearchValue = searchValue.trim().toLowerCase();
          if (!normalizedSearchValue) {
            return;
          }
          const values = (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : [];
          if (values.findIndex(tag => tag.trim().toLowerCase() === normalizedSearchValue) === -1) {
            field.onChange([...values, searchValue]);
          }
        },
        isClearable: true,
        "data-test-subj": "sloEditTagsSelector",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 13
        }
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.dashboards.label', {
      defaultMessage: 'Linked dashboards'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 22
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "artifacts.dashboards",
    control: control,
    defaultValue: undefined,
    render: ({
      field
    }) => {
      var _field$value2;
      return /*#__PURE__*/_react.default.createElement(_dashboardsSelector.DashboardsSelector, {
        contentManagement: services.contentManagement,
        dashboardsFormData: (_field$value2 = field.value) !== null && _field$value2 !== void 0 ? _field$value2 : [],
        placeholder: DASHBOARDS_COMBOBOX_PLACEHOLDER,
        onChange: selected => field.onChange(selected.map(d => ({
          id: d.value
        }))),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 13
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  })));
}
function generateTagOptions(tags = []) {
  return tags.map(tag => ({
    label: tag,
    value: tag,
    'data-test-subj': `${tag}Option`
  }));
}
const DASHBOARDS_COMBOBOX_PLACEHOLDER = _i18n.i18n.translate('xpack.slo.sloEdit.dashboards.placeholder', {
  defaultMessage: 'Add dashboards'
});