"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NEW_TIMESLICE_METRIC", {
  enumerable: true,
  get: function () {
    return _metric_indicator.NEW_TIMESLICE_METRIC;
  }
});
exports.TimesliceMetricIndicatorTypeForm = TimesliceMetricIndicatorTypeForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _index_and_timestamp_field = require("../custom_common/index_and_timestamp_field");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _group_by_field = require("../../common/group_by_field");
var _data_preview_chart = require("../../common/data_preview_chart");
var _query_builder = require("../../common/query_builder");
var _index_selection = require("../custom_common/index_selection");
var _metric_indicator = require("./metric_indicator");
var _constants = require("../../../constants");
var _use_create_data_view = require("../../../../../hooks/use_create_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/indicator_section/timeslice_metric/timeslice_metric_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TimesliceMetricIndicatorTypeForm() {
  var _dataView$fields;
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const index = watch('indicator.params.index');
  const dataViewId = watch(_index_selection.DATA_VIEW_FIELD);
  const {
    dataView,
    loading: isIndexFieldsLoading
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: index,
    dataViewId
  });
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const threshold = watch('indicator.params.metric.threshold');
  const comparator = watch('indicator.params.metric.comparator');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.sourceTitle",
    defaultMessage: "Source",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_index_and_timestamp_field.IndexAndTimestampField, {
    dataView: dataView,
    isLoading: isIndexFieldsLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "timesliceMetricIndicatorFormQueryFilterInput",
    dataView: dataView,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.queryFilter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.customFilter', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.customFilter.tooltip', {
        defaultMessage: 'This KQL query can be used to filter the documents with some relevant criteria.'
      }),
      position: "top",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.timesliceMetric.metricTitle",
    defaultMessage: "Metric definition",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_metric_indicator.MetricIndicator, {
    indexFields: (_dataView$fields = dataView === null || dataView === void 0 ? void 0 : dataView.fields) !== null && _dataView$fields !== void 0 ? _dataView$fields : [],
    isLoadingIndex: isIndexFieldsLoading,
    dataView: dataView,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_group_by_field.GroupByField, {
    dataView: dataView,
    isLoading: isIndexFieldsLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_data_preview_chart.DataPreviewChart, {
    formatPattern: uiSettings.get('format:number:defaultPattern'),
    threshold: threshold,
    thresholdDirection: ['GT', 'GTE'].includes(comparator) ? 'above' : 'below',
    thresholdColor: euiTheme.colors.warning,
    thresholdMessage: `${_constants.COMPARATOR_MAPPING[comparator]} ${threshold}`,
    ignoreMoreThan100: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  })));
}