"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelector = FieldSelector;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _reactHookForm = require("react-hook-form");
var _optional_text = require("../../common/optional_text");
var _use_fetch_synthetics_suggestions = require("../../../../../hooks/use_fetch_synthetics_suggestions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/indicator_section/synthetics_common/field_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldSelector({
  allowAllOption = true,
  dataTestSubj,
  fieldName,
  label,
  name,
  placeholder,
  tooltip,
  required,
  filters
}) {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [search, setSearch] = (0, _react.useState)('');
  const {
    suggestions = [],
    isLoading
  } = (0, _use_fetch_synthetics_suggestions.useFetchSyntheticsSuggestions)({
    filters: (0, _lodash.omit)(filters, fieldName),
    search,
    fieldName
  });
  const debouncedSearch = (0, _lodash.debounce)(value => setSearch(value), 200);
  const ALL_VALUE_OPTION = {
    value: _sloSchema.ALL_VALUE,
    label: _i18n.i18n.translate('xpack.slo.fieldSelector.all', {
      defaultMessage: 'All'
    })
  };
  const options = (allowAllOption ? [ALL_VALUE_OPTION] : []).concat(createOptions(suggestions));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: !!tooltip ? /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 13
      }
    }, label, " ", tooltip) : label,
    isInvalid: getFieldState(name).invalid,
    fullWidth: true,
    labelAppend: !required ? /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 34
      }
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: "",
    name: name,
    control: control,
    rules: {
      required
    },
    render: ({
      field,
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      "aria-label": placeholder,
      async: true,
      "data-test-subj": dataTestSubj,
      isClearable: true,
      fullWidth: true,
      isInvalid: fieldState.invalid,
      isLoading: isLoading,
      onChange: selected => {
        var _selected$at, _selected$at2;
        // removes ALL value option if a specific value is selected
        if (selected.length && ((_selected$at = selected.at(-1)) === null || _selected$at === void 0 ? void 0 : _selected$at.value) !== _sloSchema.ALL_VALUE) {
          field.onChange(selected.filter(value => value.value !== _sloSchema.ALL_VALUE));
          return;
        }
        // removes specific value if ALL value is selected
        if (selected.length && ((_selected$at2 = selected.at(-1)) === null || _selected$at2 === void 0 ? void 0 : _selected$at2.value) === _sloSchema.ALL_VALUE) {
          field.onChange([ALL_VALUE_OPTION]);
          return;
        }
        field.onChange([]);
      },
      onSearchChange: value => debouncedSearch(value),
      options: options,
      placeholder: placeholder,
      selectedOptions: !!Array.isArray(field.value) && field.value.length ? field.value.map(value => ({
        value: value.value,
        label: value.label
      })) : [],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  })));
}
function createOptions(suggestions = []) {
  return suggestions.map(suggestion => ({
    label: suggestion.label,
    value: suggestion.value
  })).sort((a, b) => String(a.label).localeCompare(b.label));
}