"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettings = AdvancedSettings;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _sync_field_selector = require("./sync_field_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/indicator_section/advanced_settings/advanced_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AdvancedSettings() {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const preventBackfillCheckbox = (0, _eui.useGeneratedHtmlId)({
    prefix: 'preventBackfill'
  });
  const advancedSettingsAccordion = (0, _eui.useGeneratedHtmlId)({
    prefix: 'advancedSettingsAccordion'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    paddingSize: "s",
    id: advancedSettingsAccordion,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "controlsVertical",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.slo.sloEdit.settings.advancedSettingsLabel', {
      defaultMessage: 'Advanced settings'
    }))))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sync_field_selector.SyncFieldSelector, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: getFieldState('settings.syncDelay').invalid,
    label: /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.slo.sloEdit.settings.syncDelay.label', {
      defaultMessage: 'Sync delay (in minutes)'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.settings.syncDelay.tooltip', {
        defaultMessage: 'The time delay in minutes between the current time and the latest source data time. Increasing the value will delay any alerting. The default value is 1 minute. The minimum value is 1m and the maximum is 359m. It should always be greater then source index refresh interval.'
      }),
      position: "top",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 19
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "settings.syncDelay",
    defaultValue: 1,
    control: control,
    rules: {
      required: true,
      min: 1,
      max: 359
    },
    render: ({
      field: {
        ref,
        onChange,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      "data-test-subj": "sloAdvancedSettingsSyncDelay",
      isInvalid: fieldState.invalid,
      required: true,
      value: field.value,
      min: 1,
      max: 359,
      step: 1,
      onChange: event => onChange(event.target.value),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 19
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: getFieldState('settings.frequency').invalid,
    label: /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.slo.sloEdit.settings.frequency.label', {
      defaultMessage: 'Frequency (in minutes)'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.settings.frequency.tooltip', {
        defaultMessage: 'The interval between checks for changes in the source data. The minimum value is 1m and the maximum is 59m. The default value is 1 minute.'
      }),
      position: "top",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 19
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "settings.frequency",
    defaultValue: 1,
    control: control,
    rules: {
      required: true,
      min: 1,
      max: 59
    },
    render: ({
      field: {
        ref,
        onChange,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      "data-test-subj": "sloAdvancedSettingsFrequency",
      isInvalid: fieldState.invalid,
      required: true,
      value: field.value,
      min: 1,
      max: 59,
      step: 1,
      onChange: event => onChange(event.target.value),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 19
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: getFieldState('settings.preventInitialBackfill').invalid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "settings.preventInitialBackfill",
    control: control,
    render: ({
      field: {
        ref,
        onChange,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: preventBackfillCheckbox,
      label: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.slo.sloEdit.settings.preventInitialBackfill.label', {
        defaultMessage: 'Prevent initial backfill of data'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.slo.sloEdit.settings.preventInitialBackfill.tooltip', {
          defaultMessage: 'Start aggregating data from the time the SLO is created, instead of backfilling data from the beginning of the time window.'
        }),
        position: "top",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 21
        }
      })),
      checked: Boolean(field.value),
      onChange: event => onChange(event.target.checked),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }))));
}