"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryDocumentsFlyoutOpenButton = QueryDocumentsFlyoutOpenButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _query_documents_flyout = require("./query_documents_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/query_documents_flyout_open_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function QueryDocumentsFlyoutOpenButton({
  name,
  dataView,
  searchBarProps
}) {
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    css: {
      marginTop: 27
    },
    isDisabled: !Boolean(dataView),
    "data-test-subj": "o11yQueryBuilderButton",
    iconType: "documents",
    onClick: () => setIsFlyoutOpen(true),
    "aria-label": _i18n.i18n.translate('xpack.slo.queryBuilder.documentsButtonLabel', {
      defaultMessage: 'View documents'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }), isFlyoutOpen && dataView && /*#__PURE__*/_react.default.createElement(_query_documents_flyout.QueryDocumentsFlyout, {
    dataView: dataView,
    name: name,
    searchBarProps: searchBarProps,
    onCloseFlyout: () => setIsFlyoutOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }));
}