"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricTimesliceEventsChart = MetricTimesliceEventsChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _public = require("@kbn/charts-plugin/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-plugin/public");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _duration = require("../../../../utils/slo/duration");
var _metric_timeslice_annotation = require("./metric_timeslice_annotation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/events_chart_panel/metric_timeslice_events_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function MetricTimesliceEventsChart({
  slo,
  data,
  onBrushed
}) {
  var _min, _max;
  const {
    charts,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const chartRef = (0, _react.useRef)(null);
  const baseTheme = charts.theme.useChartsBaseTheme();
  const dateFormat = uiSettings.get('dateFormat');
  const handleCursorUpdate = (0, _public.useActiveCursor)(charts.activeCursor, chartRef, {
    isDateHistogram: true
  });
  const {
    ObservabilityAnnotations,
    annotations,
    wrapOnBrushEnd
  } = (0, _public2.useAnnotations)({
    slo
  });
  if (slo.indicator.type !== 'sli.metric.timeslice') {
    return null;
  }
  const values = data.map(row => row.sliValue);
  const maxValue = (0, _lodash.max)(values);
  const minValue = (0, _lodash.min)(values);
  const threshold = slo.indicator.params.metric.threshold;
  const domain = {
    fit: true,
    min: (_min = (0, _lodash.min)([threshold, minValue])) !== null && _min !== void 0 ? _min : NaN,
    max: (_max = (0, _lodash.max)([threshold, maxValue])) !== null && _max !== void 0 ? _max : NaN
  };
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 150,
      width: '100%'
    },
    ref: chartRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAnnotations, {
    annotations: annotations,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: slo.indicator.type !== 'sli.metric.timeslice',
    legendPosition: _charts.Position.Left,
    noResults: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visualizeApp",
      size: "l",
      color: "subdued",
      title: _i18n.i18n.translate('xpack.slo.eventsChartPanel.euiIcon.noResultsLabel', {
        defaultMessage: 'no results'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }),
    onPointerUpdate: handleCursorUpdate,
    externalPointerEvents: {
      tooltip: {
        visible: true
      }
    },
    pointerUpdateDebounce: 0,
    pointerUpdateTrigger: 'x',
    locale: _i18n.i18n.getLocale(),
    onBrushEnd: wrapOnBrushEnd(brushArea => {
      onBrushed === null || onBrushed === void 0 ? void 0 : onBrushed((0, _duration.getBrushTimeBounds)(brushArea));
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_metric_timeslice_annotation.MetricTimesliceAnnotation, {
    slo: slo,
    minValue: minValue,
    maxValue: maxValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: d => (0, _moment.default)(d).format(dateFormat),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: _charts.Position.Left,
    tickFormat: d => (0, _numeral.default)(d).format('0,0[.00]'),
    domain: domain,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: "Metric",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "date",
    yAccessors: ['value'],
    data: data.map(datum => ({
      date: new Date(datum.date).getTime(),
      value: datum.sliValue
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }));
}