"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRatePanel = BurnRatePanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _error_rate_chart = require("../../../../components/slo/error_rate_chart");
var _use_fetch_slo_burn_rates = require("../../../../hooks/use_fetch_slo_burn_rates");
var _use_fetch_burn_rate_windows = require("../../hooks/use_fetch_burn_rate_windows");
var _burn_rate_status = require("./burn_rate_status");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/burn_rate_panel/burn_rate_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function BurnRatePanel({
  slo,
  isAutoRefreshing
}) {
  var _data$burnRates$find$, _data$burnRates$find, _data$burnRates$find$2, _data$burnRates$find2;
  const burnRateWindows = (0, _use_fetch_burn_rate_windows.useFetchBurnRateWindows)(slo);
  const [selectedWindow, setSelectedwindow] = (0, _react.useState)(burnRateWindows[0]);
  const {
    isLoading,
    data
  } = (0, _use_fetch_slo_burn_rates.useFetchSloBurnRates)({
    slo,
    shouldRefetch: isAutoRefreshing,
    windows: toPayload(burnRateWindows)
  });
  (0, _react.useEffect)(() => {
    if (burnRateWindows.length > 0) {
      setSelectedwindow(burnRateWindows[0]);
    }
  }, [burnRateWindows]);
  const onBurnRateOptionChange = windowName => {
    var _burnRateWindows$find;
    const selected = (_burnRateWindows$find = burnRateWindows.find(opt => opt.name === windowName)) !== null && _burnRateWindows$find !== void 0 ? _burnRateWindows$find : burnRateWindows[0];
    setSelectedwindow(selected);
  };
  const threshold = selectedWindow.threshold;
  const longWindowBurnRate = (_data$burnRates$find$ = data === null || data === void 0 ? void 0 : (_data$burnRates$find = data.burnRates.find(curr => curr.name === longWindowName(selectedWindow.name))) === null || _data$burnRates$find === void 0 ? void 0 : _data$burnRates$find.burnRate) !== null && _data$burnRates$find$ !== void 0 ? _data$burnRates$find$ : 0;
  const shortWindowbBurnRate = (_data$burnRates$find$2 = data === null || data === void 0 ? void 0 : (_data$burnRates$find2 = data.burnRates.find(curr => curr.name === shortWindowName(selectedWindow.name))) === null || _data$burnRates$find2 === void 0 ? void 0 : _data$burnRates$find2.burnRate) !== null && _data$burnRates$find$2 !== void 0 ? _data$burnRates$find$2 : 0;
  const currentStatus = (0, _utils.getStatus)(threshold, longWindowBurnRate, shortWindowbBurnRate);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "burnRatePanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.slo.burnRates.burnRatePanelTitle', {
    defaultMessage: 'Burn rate'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.slo.burnRate.timeRangeBtnLegend', {
      defaultMessage: 'Select the time range'
    }),
    options: burnRateWindows.map(burnRateWindow => ({
      id: burnRateWindow.name,
      label: burnRateWindowLabel(burnRateWindow),
      'aria-label': burnRateWindowLabel(burnRateWindow)
    })),
    idSelected: selectedWindow.name,
    onChange: onBurnRateOptionChange,
    buttonSize: "compressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_burn_rate_status.BurnRateStatus, {
    selectedWindow: selectedWindow,
    shortWindowBurnRate: shortWindowbBurnRate,
    longWindowBurnRate: longWindowBurnRate,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_error_rate_chart.ErrorRateChart, {
    slo: slo,
    dataTimeRange: {
      from: (0, _moment.default)().subtract(selectedWindow.longWindow.value, selectedWindow.longWindow.unit).toDate(),
      to: new Date()
    },
    threshold: threshold,
    variant: currentStatus === 'BREACHED' ? 'danger' : 'success',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  })))));
}
const burnRateWindowLabel = option => _i18n.i18n.translate('xpack.slo.burnRates.optionLabel', {
  defaultMessage: '{duration, plural, one {# hour} other {# hours}}',
  values: {
    duration: option.longWindow.value
  }
});
const longWindowName = window => `${window}_LONG`;
const shortWindowName = window => `${window}_SHORT`;
const toPayload = burnRateWindows => {
  return burnRateWindows.flatMap(window => [{
    name: longWindowName(window.name),
    duration: `${window.longWindow.value}${window.longWindow.unit}`
  }, {
    name: shortWindowName(window.name),
    duration: `${window.shortWindow.value}${window.shortWindow.unit}`
  }]);
};