"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePermissions = usePermissions;
var _common = require("@kbn/observability-plugin/common");
var _use_kibana = require("./use_kibana");
var _use_fetch_global_diagnosis = require("./use_fetch_global_diagnosis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePermissions() {
  const {
    application: {
      capabilities
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: globalDiagnosis,
    isLoading
  } = (0, _use_fetch_global_diagnosis.useFetchSloGlobalDiagnosis)();
  const hasRequiredReadCapabilities = !!capabilities[_common.sloFeatureId].read;
  const hasRequiredWriteCapabilities = !!capabilities[_common.sloFeatureId].write;
  const hasRequiredReadPrivileges = !!(globalDiagnosis !== null && globalDiagnosis !== void 0 && globalDiagnosis.userPrivileges.read.has_all_requested);
  const hasRequiredWritePrivileges = !!(globalDiagnosis !== null && globalDiagnosis !== void 0 && globalDiagnosis.userPrivileges.write.has_all_requested);
  return {
    isLoading,
    data: isLoading ? undefined : {
      capabilities: {
        read: hasRequiredReadCapabilities,
        write: hasRequiredWriteCapabilities
      },
      privileges: {
        read: hasRequiredReadPrivileges,
        write: hasRequiredWritePrivileges
      },
      hasAllReadRequested: hasRequiredReadCapabilities && hasRequiredReadPrivileges,
      hasAllWriteRequested: hasRequiredWriteCapabilities && hasRequiredWritePrivileges
    }
  };
}