"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchHistoricalSummary = useFetchHistoricalSummary;
var _sloSchema = require("@kbn/slo-schema");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../constants");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchHistoricalSummary({
  sloList = [],
  shouldRefetch,
  range
}) {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const list = sloList.map(slo => {
    var _slo$instanceId, _slo$remote;
    return {
      sloId: slo.id,
      instanceId: (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE,
      remoteName: (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName,
      timeWindow: slo.timeWindow,
      groupBy: slo.groupBy,
      revision: slo.revision,
      objective: slo.objective,
      budgetingMethod: slo.budgetingMethod,
      range: range ? {
        from: range === null || range === void 0 ? void 0 : range.from.toISOString(),
        to: range === null || range === void 0 ? void 0 : range.to.toISOString()
      } : undefined
    };
  });
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.historicalSummary(list),
    queryFn: async ({
      signal
    }) => {
      try {
        return await sloClient.fetch('POST /internal/observability/slos/_historical_summary', {
          params: {
            body: {
              list
            }
          },
          signal
        });
      } catch (error) {
        // ignore error
      }
    },
    enabled: Boolean(list.length > 0),
    refetchInterval: shouldRefetch ? _constants.SLO_LONG_REFETCH_INTERVAL : undefined,
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    isRefetching,
    isInitialLoading,
    isSuccess,
    isError
  };
}