"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloOverviewDetails = SloOverviewDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _header_title = require("../../../pages/slo_details/components/header_title");
var _slo_details = require("../../../pages/slo_details/components/slo_details");
var _use_slo_details_tabs = require("../../../pages/slo_details/hooks/use_slo_details_tabs");
var _use_slo_summary = require("../../../pages/slos/hooks/use_slo_summary");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/common/slo_overview_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloOverviewDetails({
  slo,
  setSelectedSlo
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'sloOverviewFlyout'
  });
  const onClose = () => {
    setSelectedSlo(null);
  };
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(_slo_details.OVERVIEW_TAB_ID);
  const {
    tabs
  } = (0, _use_slo_details_tabs.useSloDetailsTabs)({
    slo,
    isAutoRefreshing: false,
    selectedTabId,
    setSelectedTabId
  });
  if (!slo) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.slo.sloOverviewDetails.h2.detailsLabel', {
    defaultMessage: '{sloName}',
    values: {
      sloName: slo.name
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_title.HeaderTitle, {
    slo: slo,
    isLoading: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: index,
    onClick: 'onClick' in tab ? tab.onClick : undefined,
    isSelected: tab.id === selectedTabId,
    append: 'append' in tab ? tab.append : null,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, tab.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_details.SloDetails, {
    slo: slo,
    isAutoRefreshing: false,
    selectedTabId: selectedTabId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11ySloOverviewDetailsCloseButton",
    onClick: onClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.slo.sloOverviewDetails.button.closeLabel', {
    defaultMessage: 'Close'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: () => {
      const {
        sloDetailsUrl
      } = (0, _use_slo_summary.getSloFormattedSummary)(slo, uiSettings, basePath);
      navigateToUrl(sloDetailsUrl);
    },
    "data-test-subj": "o11ySloOverviewDetailsDetailsButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.slo.sloOverviewDetails.button.detailsLabel', {
    defaultMessage: 'Details'
  }))))));
}