"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloAlertsWrapper = SloAlertsWrapper;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _common = require("@kbn/observability-plugin/common");
var _slo_included_count = require("./components/slo_included_count");
var _slo_alerts_summary = require("./components/slo_alerts_summary");
var _slo_alerts_table = require("./components/slo_alerts_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/alerts/slo_alerts_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloAlertsWrapper({
  slos,
  deps,
  timeRange: initialTimeRange,
  onRenderComplete,
  reloadSubject,
  showAllGroupByInstances,
  onEdit
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = deps;
  const [timeRange, setTimeRange] = (0, _react.useState)(initialTimeRange);
  const [lastRefreshTime, setLastRefreshTime] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const subs = reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.subscribe(input => {
      if (input) {
        const {
          timeRange: nTimeRange
        } = input;
        if (nTimeRange && (nTimeRange.from !== timeRange.from || nTimeRange.to !== timeRange.to)) {
          setTimeRange(nTimeRange);
        }
      }
      setLastRefreshTime(Date.now());
    });
    return () => {
      subs === null || subs === void 0 ? void 0 : subs.unsubscribe();
    };
  }, [reloadSubject, timeRange.from, timeRange.to]);
  (0, _react.useEffect)(() => {
    setTimeRange(initialTimeRange);
  }, [initialTimeRange]);
  const [isSummaryLoaded, setIsSummaryLoaded] = (0, _react.useState)(false);
  const [isTableLoaded, setIsTableLoaded] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (isSummaryLoaded && isTableLoaded && onRenderComplete) {
      onRenderComplete();
    }
  }, [isSummaryLoaded, isTableLoaded, onRenderComplete]);
  const handleGoToAlertsClick = () => {
    const kuery = slos.map(slo => `(slo.id:"${slo.id}" and slo.instanceId:"${slo.instanceId}")`).join(' or ');
    navigateToUrl(`${basePath.prepend(_common.observabilityPaths.alerts)}?_a=(kuery:'${kuery}',rangeFrom:${timeRange.from},rangeTo:${timeRange.to})`);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 100%;
        overflow: scroll;
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-shared-item": "",
    justifyContent: "flexEnd",
    wrap: true,
    css: (0, _react2.css)`
          margin: 0 35px;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      onEdit();
    },
    "data-test-subj": "o11ySloAlertsWrapperSlOsIncludedLink",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, showAllGroupByInstances ? /*#__PURE__*/_react.default.createElement(_slo_included_count.SloIncludedCount, {
    slos: slos,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }) : _i18n.i18n.translate('xpack.slo.sloAlertsWrapper.sLOsIncludedFlexItemLabel', {
    defaultMessage: '{numOfSlos, number} {numOfSlos, plural, one {SLO} other {SLOs}} included',
    values: {
      numOfSlos: slos.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "o11ySloAlertsWrapperGoToAlertsLink",
    onClick: handleGoToAlertsClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloAlertsWrapper.goToAlertsFlexItemLabel",
    defaultMessage: "Go to alerts",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    style: {
      margin: '10px'
    },
    responsive: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_alerts_summary.SloAlertsSummary, {
    slos: slos,
    deps: deps,
    timeRange: timeRange,
    onLoaded: () => setIsSummaryLoaded(true),
    showAllGroupByInstances: showAllGroupByInstances,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_alerts_table.SloAlertsTable, {
    slos: slos,
    deps: deps,
    timeRange: timeRange,
    onLoaded: () => setIsTableLoaded(true),
    lastReloadRequestTime: lastRefreshTime,
    showAllGroupByInstances: showAllGroupByInstances,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }))));
}