"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloAlertsSummary = SloAlertsSummary;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _slo_alerts_table = require("./slo_alerts_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/alerts/components/slo_alerts_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_INTERVAL = '60s';
const DEFAULT_DATE_FORMAT = 'YYYY-MM-DD HH:mm';
function SloAlertsSummary({
  slos,
  deps,
  timeRange,
  onLoaded,
  showAllGroupByInstances
}) {
  var _bucketSize$intervalS, _bucketSize$dateForma;
  const {
    triggersActionsUi: {
      getAlertSummaryWidget: AlertSummaryWidget
    }
  } = deps;
  const esQuery = (0, _slo_alerts_table.useSloAlertsQuery)(slos, timeRange, showAllGroupByInstances);
  const timeBuckets = (0, _public.useTimeBuckets)();
  const bucketSize = (0, _react.useMemo)(() => (0, _public.calculateTimeRangeBucketSize)({
    from: timeRange.from,
    to: timeRange.to
  }, timeBuckets), [timeRange.from, timeRange.to, timeBuckets]);
  const alertSummaryTimeRange = (0, _public.getAlertSummaryTimeRange)({
    from: timeRange.from,
    to: timeRange.to
  }, (_bucketSize$intervalS = bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.intervalString) !== null && _bucketSize$intervalS !== void 0 ? _bucketSize$intervalS : DEFAULT_INTERVAL, (_bucketSize$dateForma = bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) !== null && _bucketSize$dateForma !== void 0 ? _bucketSize$dateForma : DEFAULT_DATE_FORMAT);
  return /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    ruleTypeIds: _ruleDataUtils.SLO_RULE_TYPE_IDS,
    consumers: [_ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.ALERTS, _ruleDataUtils.AlertConsumers.OBSERVABILITY],
    filter: esQuery,
    timeRange: alertSummaryTimeRange,
    fullSize: true,
    onLoaded: () => {
      if (onLoaded) {
        onLoaded();
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
}