"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderMenu = HeaderMenu;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../../hooks/use_kibana");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _paths = require("../../../common/locators/paths");
var _feedback_button = require("../../pages/slos/components/common/feedback_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/header_menu/header_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function HeaderMenu() {
  const {
    http,
    theme,
    docLinks
  } = (0, _use_kibana.useKibana)().services;
  const {
    appMountParameters,
    isServerless
  } = (0, _use_plugin_context.usePluginContext)();
  return /*#__PURE__*/_react.default.createElement(_public.HeaderMenuPortal, {
    setHeaderActionMenu: appMountParameters === null || appMountParameters === void 0 ? void 0 : appMountParameters.setHeaderActionMenu,
    theme$: theme.theme$,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_feedback_button.FeedbackButton, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: http.basePath.prepend('/app/observability/annotations'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.slo.home.annotations', {
    defaultMessage: 'Annotations'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: docLinks.links.observability.slo,
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.slo.headerMenu.documentation', {
    defaultMessage: 'SLO documentation'
  })), !isServerless && /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: http.basePath.prepend(`${_paths.SLOS_BASE_PATH}${_paths.SLO_SETTINGS_PATH}`),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.slo.headerMenu.settings', {
    defaultMessage: 'Settings'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: http.basePath.prepend('/app/slos/management'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.slo.home.manage', {
    defaultMessage: 'Manage SLOs'
  }))))));
}