"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloSelector = SloSelector;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_slo_definitions = require("../../hooks/use_fetch_slo_definitions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/burn_rate_rule_editor/slo_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloSelector({
  initialSlo,
  onSelected,
  errors
}) {
  const [options, setOptions] = (0, _react.useState)([]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)();
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const {
    isLoading,
    data
  } = (0, _use_fetch_slo_definitions.useFetchSloDefinitions)({
    name: searchValue
  });
  const hasError = errors !== undefined && errors.length > 0;
  (0, _react.useEffect)(() => {
    setSelectedOptions(initialSlo ? [{
      value: initialSlo.id,
      label: initialSlo.name
    }] : []);
  }, [initialSlo]);
  (0, _react.useEffect)(() => {
    var _data$results;
    const isLoadedWithData = !isLoading && !!(data !== null && data !== void 0 && data.results);
    const opts = isLoadedWithData ? data === null || data === void 0 ? void 0 : (_data$results = data.results) === null || _data$results === void 0 ? void 0 : _data$results.map(slo => ({
      value: slo.id,
      label: slo.name
    })) : [];
    setOptions(opts);
  }, [isLoading, data]);
  const onChange = opts => {
    var _data$results2;
    setSelectedOptions(opts);
    const selectedSlo = opts.length === 1 ? data === null || data === void 0 ? void 0 : (_data$results2 = data.results) === null || _data$results2 === void 0 ? void 0 : _data$results2.find(slo => slo.id === opts[0].value) : undefined;
    onSelected(selectedSlo);
  };
  const onSearchChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(value => setSearchValue(value), 300), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: rowLabel,
    fullWidth: true,
    isInvalid: hasError,
    error: hasError ? errors[0] : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.slo.rules.sloSelector.ariaLabel', {
      defaultMessage: 'SLO'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.rules.sloSelector.placeholder', {
      defaultMessage: 'Select a SLO'
    }),
    "data-test-subj": "sloSelector",
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedOptions,
    async: true,
    isLoading: isLoading,
    onChange: onChange,
    fullWidth: true,
    onSearchChange: onSearchChange,
    isInvalid: hasError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }));
}
const rowLabel = _i18n.i18n.translate('xpack.slo.rules.sloSelector.rowLabel', {
  defaultMessage: 'SLO'
});