"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSLOSummaryIndices = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @returns the local SLO summary index or the remote cluster indices based on the settings.
 * If `useAllRemoteClusters` is false and no remote clusters are selected it returns only the local index.
 * If `useAllRemoteClusters` is true, it returns both the local index and a wildcard remote index.
 * If `useAllRemoteClusters` is false, it returns the local index and only the indices of the selected remote clusters that are connected.
 */
const getSLOSummaryIndices = (settings, remoteClusters = []) => {
  const {
    useAllRemoteClusters,
    selectedRemoteClusters
  } = settings;
  if (!useAllRemoteClusters && selectedRemoteClusters.length === 0) {
    return [_constants.SUMMARY_DESTINATION_INDEX_PATTERN];
  }
  if (useAllRemoteClusters) {
    return [_constants.SUMMARY_DESTINATION_INDEX_PATTERN, `*:${_constants.SUMMARY_DESTINATION_INDEX_PATTERN}`];
  }
  return remoteClusters.reduce((acc, {
    name,
    isConnected
  }) => {
    if (isConnected && selectedRemoteClusters.includes(name)) {
      acc.push(`${name}:${_constants.SUMMARY_DESTINATION_INDEX_PATTERN}`);
    }
    return acc;
  }, [_constants.SUMMARY_DESTINATION_INDEX_PATTERN]);
};
exports.getSLOSummaryIndices = getSLOSummaryIndices;