"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareMenuTabs = exports.ShareMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxTabbedModal = require("@kbn/shared-ux-tabbed-modal");
var _context = require("./context");
var _tabs = require("./tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/share/public/components/share_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ShareMenu = ({
  shareContext
}) => {
  return /*#__PURE__*/_react.default.createElement(_context.ShareProvider, {
    shareContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ShareMenuTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 7
    }
  }));
};

// this file is intended to replace share_context_menu
exports.ShareMenu = ShareMenu;
const ShareMenuTabs = () => {
  var _objectTypeMeta$confi, _objectTypeMeta$confi2, _objectTypeMeta$confi3;
  const shareContext = (0, _context.useShareContext)();
  const {
    objectTypeMeta,
    onClose,
    shareMenuItems,
    anchorElement
  } = shareContext;
  const tabs = [];

  // Do not show the link tab if the share url is disabled
  if (!(objectTypeMeta !== null && objectTypeMeta !== void 0 && (_objectTypeMeta$confi = objectTypeMeta.config.link) !== null && _objectTypeMeta$confi !== void 0 && _objectTypeMeta$confi.disabled)) {
    tabs.push(_tabs.linkTab);
  }

  // Embed is disabled in the serverless offering, hence the need to check if the embed tab should be shown
  if (shareMenuItems.some(({
    shareType
  }) => shareType === 'embed') && !(objectTypeMeta !== null && objectTypeMeta !== void 0 && (_objectTypeMeta$confi2 = objectTypeMeta.config) !== null && _objectTypeMeta$confi2 !== void 0 && (_objectTypeMeta$confi3 = _objectTypeMeta$confi2.embed) !== null && _objectTypeMeta$confi3 !== void 0 && _objectTypeMeta$confi3.disabled)) {
    tabs.push(_tabs.embedTab);
  }
  return Boolean(tabs.length) ? /*#__PURE__*/_react.default.createElement(_sharedUxTabbedModal.TabbedModal, {
    tabs: tabs,
    modalWidth: 498,
    onClose: onClose,
    modalTitle: objectTypeMeta.title,
    defaultSelectedTabId: tabs[0].id,
    anchorElement: anchorElement,
    "data-test-subj": "shareContextModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }) : null;
};
exports.ShareMenuTabs = ShareMenuTabs;