"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TTYTextSizer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _translations = require("./translations");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/tty_text_sizer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const commonButtonProps = {
  display: 'empty',
  size: 's',
  color: 'text'
};
const LINE_HEIGHT_SCALE_RATIO = 1.3;
const MINIMUM_FONT_SIZE = 2;
const MAXIMUM_FONT_SIZE = 20;
const TTYTextSizer = ({
  tty,
  containerHeight,
  fontSize,
  onFontSizeChanged
}) => {
  const styles = (0, _styles.useStyles)();
  const [fit, setFit] = (0, _react.useState)(false);
  const onZoomOut = (0, _react.useCallback)(() => {
    setFit(false);
    onFontSizeChanged(Math.max(MINIMUM_FONT_SIZE, fontSize - 1));
  }, [fontSize, onFontSizeChanged]);
  const onZoomIn = (0, _react.useCallback)(() => {
    setFit(false);
    onFontSizeChanged(Math.min(MAXIMUM_FONT_SIZE, fontSize + 1));
  }, [fontSize, onFontSizeChanged]);
  (0, _react.useEffect)(() => {
    if (fit && tty !== null && tty !== void 0 && tty.rows && containerHeight) {
      const lineHeight = _constants.DEFAULT_TTY_FONT_SIZE * LINE_HEIGHT_SCALE_RATIO;
      const desiredHeight = tty.rows * lineHeight;
      const newSize = Math.floor(_constants.DEFAULT_TTY_FONT_SIZE * (containerHeight / desiredHeight));
      if (newSize !== fontSize) {
        onFontSizeChanged(newSize);
      }
    }
  }, [containerHeight, fit, fontSize, onFontSizeChanged, tty === null || tty === void 0 ? void 0 : tty.rows]);
  const onToggleFit = (0, _react.useCallback)(() => {
    const newValue = !fit;
    setFit(newValue);
    if (!newValue) {
      onFontSizeChanged(_constants.DEFAULT_TTY_FONT_SIZE);
    }
  }, [fit, setFit, onFontSizeChanged]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "sessionView:TTYTextSizer",
    alignItems: "center",
    gutterSize: "s",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.separator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.ZOOM_FIT,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "sessionView:TTYZoomFit",
    "aria-label": _translations.ZOOM_FIT,
    display: fit ? 'fill' : 'empty',
    iconType: fit ? 'expand' : 'minimize',
    onClick: onToggleFit,
    size: "s",
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.separator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.ZOOM_OUT,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYZoomOut",
    "aria-label": _translations.ZOOM_OUT,
    iconType: "minusInCircle",
    onClick: onZoomOut
  }, commonButtonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    css: styles.ratio,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, `${Math.round(fontSize / _constants.DEFAULT_TTY_FONT_SIZE * 100)}%`), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.ZOOM_IN,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYZoomIn",
    "aria-label": _translations.ZOOM_IN,
    iconType: "plusInCircle",
    onClick: onZoomIn
  }, commonButtonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  })))));
};
exports.TTYTextSizer = TTYTextSizer;