"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TTYPlayerControls = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _styles = require("./styles");
var _translations = require("./translations");
var _tty_player_controls_markers = require("./tty_player_controls_markers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/tty_player_controls/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TTYPlayerControls = ({
  currentProcessEvent,
  processStartMarkers,
  isPlaying,
  currentLine,
  linesLength,
  onSeekLine,
  onTogglePlayback,
  onClose,
  onJumpToEvent,
  textSizer
}) => {
  const styles = (0, _styles.useStyles)();
  const commonButtonProps = {
    display: 'empty',
    size: 's',
    color: 'text',
    css: styles.controlButton
  };
  const onLineChange = (0, _react.useCallback)(event => {
    const line = parseInt(event.currentTarget.value || '0', 10);
    onSeekLine(line);
  }, [onSeekLine]);
  const seekToStart = (0, _react.useCallback)(() => {
    onSeekLine(0);
  }, [onSeekLine]);
  const seekToEnd = (0, _react.useCallback)(() => {
    onSeekLine(linesLength - 1);
  }, [linesLength, onSeekLine]);
  const seekToPrevProcess = (0, _react.useCallback)(() => {
    const index = currentLine > processStartMarkers[processStartMarkers.length - 1].line ? processStartMarkers.length : (0, _lodash.findIndex)(processStartMarkers, marker => marker.line >= currentLine);
    const previousMarker = processStartMarkers[index - 1];
    onSeekLine((previousMarker === null || previousMarker === void 0 ? void 0 : previousMarker.line) || 0);
  }, [processStartMarkers, onSeekLine, currentLine]);
  const seekToNextProcess = (0, _react.useCallback)(() => {
    const nextIndex = (0, _lodash.findIndex)(processStartMarkers, marker => {
      if (marker.line > currentLine) {
        return true;
      }
      return false;
    });
    const nextMarker = processStartMarkers[nextIndex];
    onSeekLine((nextMarker === null || nextMarker === void 0 ? void 0 : nextMarker.line) || linesLength - 1);
  }, [processStartMarkers, onSeekLine, linesLength, currentLine]);
  const handleViewInSession = (0, _react.useCallback)(() => {
    if (currentProcessEvent) {
      onJumpToEvent(currentProcessEvent);
      onClose();
    }
  }, [currentProcessEvent, onClose, onJumpToEvent]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: styles.controlsPanel,
    "data-test-subj": "sessionView:TTYPlayerControls",
    hasShadow: false,
    borderRadius: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TTY_START,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYPlayerControlsStart",
    iconType: "arrowStart",
    "aria-label": _translations.TTY_START,
    onClick: seekToStart
  }, commonButtonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TTY_PREVIOUS,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYPlayerControlsPrevious",
    iconType: "arrowLeft",
    "aria-label": _translations.TTY_PREVIOUS,
    onClick: seekToPrevProcess
  }, commonButtonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isPlaying ? _translations.TTY_PAUSE : _translations.TTY_PLAY,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYPlayerControlsPlay",
    iconType: isPlaying ? 'pause' : 'playFilled',
    "aria-label": isPlaying ? _translations.TTY_PAUSE : _translations.TTY_PLAY,
    onClick: onTogglePlayback
  }, commonButtonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TTY_NEXT,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYPlayerControlsNext",
    iconType: "arrowRight",
    "aria-label": _translations.TTY_NEXT,
    onClick: seekToNextProcess
  }, commonButtonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TTY_END,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYPlayerControlsEnd",
    iconType: "arrowEnd",
    "aria-label": _translations.TTY_END,
    onClick: seekToEnd
  }, commonButtonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      position: 'relative'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_tty_player_controls_markers.TTYPlayerControlsMarkers, {
    processStartMarkers: processStartMarkers,
    linesLength: linesLength,
    currentLine: currentLine,
    onChange: onLineChange,
    onSeekLine: onSeekLine,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "right",
    size: "s",
    onClick: handleViewInSession,
    iconType: "arrowRight",
    "aria-label": _translations.VIEW_IN_SESSION,
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, _translations.VIEW_IN_SESSION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, textSizer)));
};
exports.TTYPlayerControls = TTYPlayerControls;