"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SessionView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _byteSize = _interopRequireDefault(require("byte-size"));
var _shared_imports = require("../../shared_imports");
var _process_tree = require("../process_tree");
var _session_view_display_options = require("../session_view_display_options");
var _session_view_search_bar = require("../session_view_search_bar");
var _tty_player = require("../tty_player");
var _styles = require("./styles");
var _hooks = require("./hooks");
var _constants = require("../../../common/constants");
var _methods = require("../../methods");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/session_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * The main wrapper component for the session view.
 */
const SessionView = ({
  index,
  sessionEntityId,
  sessionStartTime,
  height,
  jumpToEntityId,
  jumpToCursor,
  investigatedAlertId,
  loadAlertDetails,
  canReadPolicyManagement,
  trackEvent,
  openDetails,
  closeDetails,
  resetJumpToEntityId,
  resetJumpToCursor
}) => {
  var _data$pages, _fetchAlertStatus$;
  // don't engage jumpTo if jumping to session leader.
  if (jumpToEntityId === sessionEntityId) {
    jumpToEntityId = undefined;
    jumpToCursor = undefined;
  }

  // track session open telemetry
  (0, _react.useEffect)(() => {
    const sourceMap = {
      [_methods.ENDPOINT_INDEX]: _methods.ELASTIC_DEFEND_DATA_SOURCE,
      [_methods.AUDITBEAT_INDEX]: _methods.AUDITBEAT_DATA_SOURCE
    };
    const source = sourceMap[index] || 'unknown';
    const eventKey = `loaded_from_${source}_${investigatedAlertId ? 'alert' : 'log'}`;
    trackEvent(eventKey);
  }, [index, investigatedAlertId, trackEvent]);
  const [showTTY, setShowTTY] = (0, _react.useState)(false);
  const [selectedProcess, setSelectedProcess] = (0, _react.useState)(null);
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const [searchResults, setSearchResults] = (0, _react.useState)(null);
  const [displayOptions, setDisplayOptions] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_DISPLAY_OPTIONS_KEY, {
    timestamp: true,
    verboseMode: false
  });
  const [fetchAlertStatus, setFetchAlertStatus] = (0, _react.useState)([]);
  const [updatedAlertsStatus, setUpdatedAlertsStatus] = (0, _react.useState)({});
  const [currentJumpToCursor, setCurrentJumpToCursor] = (0, _react.useState)(jumpToCursor);
  const [currentJumpToEntityId, setCurrentJumpToEntityId] = (0, _react.useState)(jumpToEntityId);
  const [currentJumpToOutputEntityId, setCurrentJumpToOutputEntityId] = (0, _react.useState)('');
  const styles = (0, _styles.useStyles)({
    height
  });

  // to give an indication to the user that there may be more search results if they turn on verbose mode.
  const showVerboseSearchTooltip = (0, _react.useMemo)(() => {
    return !!(!(displayOptions !== null && displayOptions !== void 0 && displayOptions.verboseMode) && searchQuery && (searchResults === null || searchResults === void 0 ? void 0 : searchResults.length) === 0);
  }, [displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.verboseMode, searchResults, searchQuery]);
  const onProcessSelected = (0, _react.useCallback)((process, isManualSelection = false) => {
    setSelectedProcess(process);

    // This refreshes the detailed panel rendered in the flyout preview panel
    // the isManualSelection prevents the detailed panel to render on first load of the SessionView component
    if (isManualSelection) {
      openDetails(process);
    }
  }, [openDetails]);
  const onJumpToEvent = (0, _react.useCallback)(event => {
    if (event.process) {
      const {
        entity_id: entityId
      } = event.process;
      if (entityId !== sessionEntityId) {
        var _event$kibana;
        const alert = (_event$kibana = event.kibana) === null || _event$kibana === void 0 ? void 0 : _event$kibana.alert;
        const cursor = alert ? alert === null || alert === void 0 ? void 0 : alert.original_time : event['@timestamp'];
        if (cursor) {
          setCurrentJumpToEntityId(entityId);
          setCurrentJumpToCursor(cursor);
        }
      }
      setSelectedProcess(null);
    }
  }, [sessionEntityId]);
  const onJumpToOutput = (0, _react.useCallback)(entityId => {
    setCurrentJumpToOutputEntityId(entityId);
    setShowTTY(true);
  }, []);
  const {
    data,
    error,
    fetchNextPage,
    hasNextPage,
    isFetching,
    fetchPreviousPage,
    hasPreviousPage,
    refetch
  } = (0, _hooks.useFetchSessionViewProcessEvents)(index, sessionEntityId, sessionStartTime, currentJumpToCursor);
  const {
    error: alertsError,
    refetch: refetchAlerts
  } = (0, _hooks.useFetchSessionViewAlerts)(sessionEntityId, sessionStartTime, investigatedAlertId);
  const {
    data: totalTTYOutputBytes,
    refetch: refetchTotalTTYOutput
  } = (0, _hooks.useFetchGetTotalIOBytes)(index, sessionEntityId, sessionStartTime);
  const hasTTYOutput = !!(totalTTYOutputBytes !== null && totalTTYOutputBytes !== void 0 && totalTTYOutputBytes.total);
  const bytesOfOutput = (0, _react.useMemo)(() => {
    const {
      unit,
      value
    } = (0, _byteSize.default)((totalTTYOutputBytes === null || totalTTYOutputBytes === void 0 ? void 0 : totalTTYOutputBytes.total) || 0);
    return {
      unit,
      value
    };
  }, [totalTTYOutputBytes === null || totalTTYOutputBytes === void 0 ? void 0 : totalTTYOutputBytes.total]);
  const onToggleTTY = (0, _react.useCallback)(() => {
    if (hasTTYOutput) {
      setShowTTY(!showTTY);

      // This closes the detailed panel rendered in the flyout preview panel when the user activate the TTY output mode
      // then reopens the detailed panel to the previously selected process when the user deactivates the TTY output mode
      if (!showTTY) {
        closeDetails();
      }
      if (showTTY) {
        openDetails(selectedProcess);
      }
      trackEvent('tty_loaded');
    } else {
      trackEvent('disabled_tty_clicked');
    }
  }, [closeDetails, hasTTYOutput, openDetails, selectedProcess, showTTY, trackEvent]);
  const handleRefresh = (0, _react.useCallback)(() => {
    refetch({
      refetchPage: (_page, i, allPages) => allPages.length - 1 === i
    });
    refetchAlerts({
      refetchPage: (_page, i, allPages) => allPages.length - 1 === i
    });
    refetchTotalTTYOutput();
    trackEvent('refresh_clicked');
  }, [refetch, refetchAlerts, refetchTotalTTYOutput, trackEvent]);
  const hasError = error || alertsError;
  const dataLoaded = data && ((_data$pages = data.pages) === null || _data$pages === void 0 ? void 0 : _data$pages.length) > (jumpToCursor ? 1 : 0);
  const renderIsLoading = isFetching && !dataLoaded;
  const hasData = dataLoaded && data.pages[0].events.length > 0;
  const {
    data: newUpdatedAlertsStatus
  } = (0, _hooks.useFetchAlertStatus)(updatedAlertsStatus, (_fetchAlertStatus$ = fetchAlertStatus[0]) !== null && _fetchAlertStatus$ !== void 0 ? _fetchAlertStatus$ : '');

  /**
   * This useEffect should only impact the SessionView component when displayed in the expandable flyout.
   * The SessionView tree and its detailed panel are separated and this allows the detailed panel to reset the
   * view of the tree from the preview panel.
   */
  (0, _react.useEffect)(() => {
    if (resetJumpToEntityId && resetJumpToCursor) {
      setSelectedProcess(null);
      setCurrentJumpToEntityId(resetJumpToEntityId);
      setCurrentJumpToCursor(resetJumpToCursor);
    }
  }, [resetJumpToCursor, resetJumpToEntityId]);
  (0, _react.useEffect)(() => {
    if (newUpdatedAlertsStatus) {
      setUpdatedAlertsStatus({
        ...newUpdatedAlertsStatus
      });
      // clearing alertUuids fetched without triggering a re-render
      fetchAlertStatus.shift();
    }
  }, [newUpdatedAlertsStatus, fetchAlertStatus]);
  const onSearchIndexChange = (0, _react.useCallback)(i => {
    if (searchResults) {
      const process = searchResults[i];
      if (process) {
        onProcessSelected(process);
      }
    }
  }, [onProcessSelected, searchResults]);
  (0, _react.useEffect)(() => {
    onSearchIndexChange(0);
  }, [onSearchIndexChange, searchResults]);
  const handleOnAlertDetailsClosed = (0, _react.useCallback)(alertUuid => {
    setFetchAlertStatus([alertUuid]);
  }, []);
  const toggleDetailPanel = (0, _react.useCallback)(() => {
    openDetails(selectedProcess);
  }, [openDetails, selectedProcess]);
  const onShowAlertDetails = (0, _react.useCallback)(alertUuid => {
    if (loadAlertDetails) {
      loadAlertDetails(alertUuid, () => handleOnAlertDetailsClosed(alertUuid));
      trackEvent('alert_details_loaded');
    }
  }, [loadAlertDetails, trackEvent, handleOnAlertDetailsClosed]);
  const handleOptionChange = (0, _react.useCallback)(checkedOptions => {
    setDisplayOptions(checkedOptions);
    if (checkedOptions.verboseMode !== (displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.verboseMode)) {
      if (checkedOptions.verboseMode) {
        trackEvent('verbose_mode_enabled');
      } else {
        trackEvent('verbose_mode_disabled');
      }
    }
    if (checkedOptions.timestamp !== (displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.timestamp)) {
      if (checkedOptions.timestamp) {
        trackEvent('timestamp_enabled');
      } else {
        trackEvent('timestamp_disabled');
      }
    }
  }, [displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.timestamp, displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.verboseMode, setDisplayOptions, trackEvent]);
  const errorEmptyPrompt = (0, _react.useMemo)(() => hasError ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.sessionView.errorHeading",
      defaultMessage: "Error loading Session View",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 15
      }
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.sessionView.errorMessage",
      defaultMessage: "There was an error loading the Session View.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  }) : null, [hasError]);
  const processTree = (0, _react.useMemo)(() => hasData ? /*#__PURE__*/_react.default.createElement("div", {
    css: styles.processTree,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_process_tree.ProcessTree, {
    key: sessionEntityId + currentJumpToCursor,
    sessionEntityId: sessionEntityId,
    data: data.pages,
    searchQuery: searchQuery,
    selectedProcess: selectedProcess,
    onProcessSelected: onProcessSelected,
    onJumpToOutput: onJumpToOutput,
    jumpToEntityId: currentJumpToEntityId,
    investigatedAlertId: investigatedAlertId,
    isFetching: isFetching,
    hasPreviousPage: hasPreviousPage,
    hasNextPage: hasNextPage,
    fetchNextPage: fetchNextPage,
    fetchPreviousPage: fetchPreviousPage,
    setSearchResults: setSearchResults,
    updatedAlertsStatus: updatedAlertsStatus,
    onShowAlertDetails: onShowAlertDetails,
    showTimestamp: displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.timestamp,
    verboseMode: displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.verboseMode,
    trackEvent: trackEvent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 11
    }
  })) : null, [currentJumpToCursor, currentJumpToEntityId, data === null || data === void 0 ? void 0 : data.pages, displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.timestamp, displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.verboseMode, fetchNextPage, fetchPreviousPage, hasData, hasNextPage, hasPreviousPage, investigatedAlertId, isFetching, onJumpToOutput, onProcessSelected, onShowAlertDetails, searchQuery, selectedProcess, sessionEntityId, styles.processTree, trackEvent, updatedAlertsStatus]);
  if (renderIsLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 377,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.sessionView.loadingProcessTree",
      defaultMessage: "Loading session\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 9
      }
    }));
  }
  if (!hasData) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "sessionView:sessionViewProcessEventsEmpty",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 391,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.sessionView.emptyDataTitle",
        defaultMessage: "No data to render",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 392,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 399,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.sessionView.emptyDataMessage",
        defaultMessage: "No process events found for this query.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 400,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 388,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.sessionViewerComponent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    borderRadius: "none",
    className: "sessionViewerToolbar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "sessionView:sessionViewProcessEventsSearch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_session_view_search_bar.SessionViewSearchBar, {
    searchQuery: searchQuery,
    totalMatches: (searchResults === null || searchResults === void 0 ? void 0 : searchResults.length) || 0,
    setSearchQuery: setSearchQuery,
    onPrevious: onSearchIndexChange,
    onNext: onSearchIndexChange,
    trackEvent: trackEvent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, bytesOfOutput.value, " ", bytesOfOutput.unit, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.sessionView.ttyToggleTip",
      defaultMessage: " of TTY output",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    isSelected: showTTY,
    display: showTTY ? 'fill' : 'empty',
    iconType: "apmTrace",
    onClick: onToggleTTY,
    size: "m",
    "aria-label": _translations.TOGGLE_TTY_PLAYER,
    "data-test-subj": "sessionView:TTYPlayerToggle",
    css: !hasTTYOutput && styles.fakeDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 450,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "refresh",
    display: "empty",
    onClick: handleRefresh,
    size: "m",
    "aria-label": _translations.REFRESH_SESSION,
    "data-test-subj": "sessionView:sessionViewRefreshButton",
    isLoading: isFetching,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 451,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_session_view_display_options.SessionViewDisplayOptions, {
    displayOptions: displayOptions,
    onChange: handleOptionChange,
    showVerboseSearchTooltip: showVerboseSearchTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 463,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 470,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: toggleDetailPanel,
    iconType: "list",
    "aria-label": _i18n.i18n.translate('xpack.sessionView.detailsPanelButton.ariaLabel', {
      defaultMessage: 'Open details panel'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 481,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errorEmptyPrompt, processTree), /*#__PURE__*/_react.default.createElement(_tty_player.TTYPlayer, {
    index: index,
    show: showTTY,
    sessionEntityId: sessionEntityId,
    sessionStartTime: sessionStartTime,
    onClose: onToggleTTY,
    onJumpToEvent: onJumpToEvent,
    autoSeekToEntityId: currentJumpToOutputEntityId,
    canReadPolicyManagement: canReadPolicyManagement,
    trackEvent: trackEvent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 486,
      columnNumber: 7
    }
  }));
};
// eslint-disable-next-line import/no-default-export
exports.default = exports.SessionView = SessionView;