"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelDescriptionList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/detail_panel_description_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Description list in session view detail panel.
 */
const DetailPanelDescriptionList = ({
  listItems
}) => {
  const styles = (0, _styles.useStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    columnWidths: [2, 3],
    listItems: listItems,
    css: styles.descriptionList,
    titleProps: {
      css: styles.tabListTitle
    },
    descriptionProps: {
      css: styles.tabListDescription
    },
    "data-test-subj": "sessionView:detail-panel-description-list",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  });
};
exports.DetailPanelDescriptionList = DetailPanelDescriptionList;