"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const copyButton = {
      position: 'absolute',
      right: euiTheme.size.s,
      top: 0,
      bottom: 0,
      margin: 'auto'
    };
    return {
      copyButton
    };
  }, [euiTheme]);
  return cached;
};
exports.useStyles = useStyles;