"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelCopy = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _detail_panel_list_item = require("../detail_panel_list_item");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/detail_panel_copy/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Copy to clipboard component in Session view detail panel.
 */
const DetailPanelCopy = ({
  children,
  textToCopy,
  tooltipContent,
  display = 'inlineBlock'
}) => {
  const styles = (0, _styles.useStyles)();
  const props = {
    copy: /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: textToCopy,
      tooltipProps: {
        display
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 7
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      css: styles.copyButton,
      onClick: copy,
      display: "base",
      iconType: "copyClipboard",
      size: "xs",
      "aria-label": _i18n.i18n.translate('xpack.sessionView.detailPanelCopy.copyButton', {
        defaultMessage: 'Copy'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    }))
  };
  if (display === 'block') {
    props.display = display;
  }
  return /*#__PURE__*/_react.default.createElement(_detail_panel_list_item.DetailPanelListItem, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
};
exports.DetailPanelCopy = DetailPanelCopy;