"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHOW_DETAILS_TEST_ID = exports.JUMP_TO_PROCESS_TEST_ID = exports.DetailPanelAlertActions = exports.BUTTON_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/detail_panel_alert_actions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BUTTON_TEST_ID = exports.BUTTON_TEST_ID = 'sessionView:detailPanelAlertActionsBtn';
const SHOW_DETAILS_TEST_ID = exports.SHOW_DETAILS_TEST_ID = 'sessionView:detailPanelAlertActionShowDetails';
const JUMP_TO_PROCESS_TEST_ID = exports.JUMP_TO_PROCESS_TEST_ID = 'sessionView:detailPanelAlertActionJumpToProcess';
/**
 * Detail panel alert context menu actions
 */
const DetailPanelAlertActions = ({
  event,
  onShowAlertDetails,
  onJumpToEvent
}) => {
  var _event$kibana$alert$u, _event$kibana2, _event$kibana2$alert;
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onClosePopover = (0, _react.useCallback)(() => {
    setPopover(false);
  }, []);
  const onToggleMenu = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [isPopoverOpen]);
  const onJumpToAlert = (0, _react.useCallback)(() => {
    onJumpToEvent(event);
    setPopover(false);
  }, [event, onJumpToEvent]);
  const onShowDetails = (0, _react.useCallback)(() => {
    var _event$kibana, _event$kibana$alert;
    if ((_event$kibana = event.kibana) !== null && _event$kibana !== void 0 && (_event$kibana$alert = _event$kibana.alert) !== null && _event$kibana$alert !== void 0 && _event$kibana$alert.uuid) {
      onShowAlertDetails(event.kibana.alert.uuid);
      setPopover(false);
    }
  }, [event, onShowAlertDetails]);
  if (!event.kibana) {
    return null;
  }
  const uuid = (_event$kibana$alert$u = (_event$kibana2 = event.kibana) === null || _event$kibana2 === void 0 ? void 0 : (_event$kibana2$alert = _event$kibana2.alert) === null || _event$kibana2$alert === void 0 ? void 0 : _event$kibana2$alert.uuid) !== null && _event$kibana$alert$u !== void 0 ? _event$kibana$alert$u : '';
  const menuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "details",
    "data-test-subj": SHOW_DETAILS_TEST_ID,
    onClick: onShowDetails,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.detailPanelAlertListItem.showDetailsAction",
    defaultMessage: "View alert details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "jumpTo",
    "data-test-subj": JUMP_TO_PROCESS_TEST_ID,
    onClick: onJumpToAlert,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.detailPanelAlertListItem.jumpToAlert",
    defaultMessage: "Jump to alerted process",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: uuid,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "empty",
      size: "s",
      iconType: "boxesHorizontal",
      "aria-label": _i18n.i18n.translate('xpack.sessionView.detailPanelAlertListItem.moreButton', {
        defaultMessage: 'More'
      }),
      "data-test-subj": BUTTON_TEST_ID,
      onClick: onToggleMenu,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: onClosePopover,
    panelPaddingSize: "none",
    anchorPosition: "leftCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: menuItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }));
};
exports.DetailPanelAlertActions = DetailPanelAlertActions;