"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _detail_panel_description_list = require("../detail_panel_description_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/detail_panel_accordion/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * An accordion section in session view detail panel.
 */
const DetailPanelAccordion = ({
  id,
  listItems,
  title,
  tooltipContent,
  extraActionTitle,
  onExtraActionClick,
  children,
  initialIsOpen = false
}) => {
  const styles = (0, _styles.useStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    arrowDisplay: "right",
    initialIsOpen: initialIsOpen,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      css: styles.accordionButton,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }, title)), tooltipContent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "sessionView:detail-panel-accordion-tooltip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: tooltipContent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 15
      }
    })))
    // extraAction={
    //   extraActionTitle ? (
    //     <EuiButtonEmpty
    //       size="s"
    //       color="primary"
    //       onClick={onExtraActionClick}
    //       data-test-subj="sessionView:detail-panel-accordion-action"
    //     >
    //       {extraActionTitle}
    //     </EuiButtonEmpty>
    //   ) : null
    // }
    ,
    css: styles.accordion,
    "data-test-subj": "sessionView:detail-panel-accordion",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_detail_panel_description_list.DetailPanelDescriptionList, {
    listItems: listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), children);
};
exports.DetailPanelAccordion = DetailPanelAccordion;