"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverlessCommonSettings = require("@kbn/serverless-common-settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessPlugin {
  setupProjectSettings(core, keys) {
    const settings = [..._serverlessCommonSettings.ALL_COMMON_SETTINGS].concat(keys);
    core.uiSettings.setAllowlist(settings);
    this.projectSettingsAdded = true;
  }
  constructor() {
    (0, _defineProperty2.default)(this, "projectSettingsAdded", false);
  }
  setup(core) {
    return {
      setupProjectSettings: keys => this.setupProjectSettings(core, keys)
    };
  }
  start(_core) {
    if (!this.projectSettingsAdded) {
      throw new Error("The uiSettings allowlist for serverless hasn't been set up. Make sure to set up your serverless project settings with setupProjectSettings()");
    }
    return {};
  }
  stop() {}
}
exports.ServerlessPlugin = ServerlessPlugin;