"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditConnector = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18n_string = require("../../../../common/i18n_string");
var _use_kibana = require("../../hooks/use_kibana");
var _edit_name = require("./edit_name");
var _edit_service_type = require("./edit_service_type");
var _edit_description = require("./edit_description");
var _delete_connector_modal = require("./delete_connector_modal");
var _connector_configuration = require("./connector_config/connector_configuration");
var _use_connector = require("../../hooks/api/use_connector");
var _use_connectors = require("../../hooks/api/use_connectors");
var _connector_privileges_callout = require("./connector_config/connector_privileges_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/serverless_search/public/application/components/connectors/edit_connector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditConnector = () => {
  const [deleteModalIsOpen, setDeleteModalIsOpen] = (0, _react.useState)(false);
  const [menuIsOpen, setMenuIsOpen] = (0, _react.useState)(false);
  const {
    data: connectorsData
  } = (0, _use_connectors.useConnectors)();
  const isDisabled = !(connectorsData !== null && connectorsData !== void 0 && connectorsData.canManageConnectors);
  const {
    id
  } = (0, _reactRouterDom.useParams)();
  (0, _react.useEffect)(() => setDeleteModalIsOpen(false), [id, setDeleteModalIsOpen]);
  const {
    application: {
      navigateToUrl
    }
  } = (0, _use_kibana.useKibanaServices)();
  const {
    data,
    isLoading
  } = (0, _use_connector.useConnector)(id);
  if (!data || isLoading) {
    /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
      offset: 0,
      grow: true,
      restrictWidth: true,
      "data-test-subj": "svlSearchEditConnectorsPage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.loading', {
        defaultMessage: 'Loading'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 7
      }
    }));
  }
  if (!(data !== null && data !== void 0 && data.connector)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
      offset: 0,
      grow: true,
      restrictWidth: true,
      "data-test-subj": "svlSearchEditConnectorsPage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.notFound', {
        defaultMessage: 'Could not find connector {id}',
        values: {
          id
        }
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "serverlessSearchEditConnectorGoBackButton",
        color: "primary",
        fill: true,
        onClick: () => navigateToUrl(`./`),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.goBack', {
        defaultMessage: 'Go back'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }));
  }
  const {
    connector
  } = data;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    grow: true,
    restrictWidth: true,
    "data-test-subj": "svlSearchEditConnectorsPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    grow: false,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, _i18n_string.CONNECTOR_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_name.EditName, {
    connector: connector,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, deleteModalIsOpen && /*#__PURE__*/_react.default.createElement(_delete_connector_modal.DeleteConnectorModal, {
    closeDeleteModal: () => setDeleteModalIsOpen(false),
    connectorId: connector.id,
    connectorName: connector.name,
    onSuccess: () => navigateToUrl('./'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: 'connectorMenu',
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "serverlessSearchEditConnectorButton",
      "aria-label": _i18n.i18n.translate('xpack.serverlessSearch.connectors.openMenuLabel', {
        defaultMessage: 'Open menu'
      }),
      iconType: "boxesVertical",
      onClick: () => setMenuIsOpen(!menuIsOpen),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 19
      }
    }),
    isOpen: menuIsOpen,
    closePopover: () => setMenuIsOpen(false),
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    "data-test-subj": "serverlessSearchEditConnectorContextMenu",
    panels: [{
      id: 0,
      items: [{
        name: _i18n_string.COPY_CONNECTOR_ID_LABEL,
        icon: 'copy',
        onClick: () => {
          (0, _eui.copyToClipboard)(connector.id);
          setMenuIsOpen(false);
        }
      }, {
        name: _i18n_string.DELETE_CONNECTOR_LABEL,
        disabled: isDisabled,
        icon: 'trash',
        onClick: () => {
          setDeleteModalIsOpen(true);
        }
      }]
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_privileges_callout.ConnectorPrivilegesCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_service_type.EditServiceType, {
    isDisabled: isDisabled,
    connector: connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_edit_description.EditDescription, {
    isDisabled: isDisabled,
    connector: connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_configuration.ConnectorConfiguration, {
    connector: connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }))))));
};
exports.EditConnector = EditConnector;