"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessObservabilityPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _managementCardsNavigation = require("@kbn/management-cards-navigation");
var _rxjs = require("rxjs");
var _navigation_tree = require("./navigation_tree");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessObservabilityPlugin {
  setup(_core, _setupDeps) {
    return {};
  }
  start(core, setupDeps) {
    var _setupDeps$streams, _core$application$cap;
    const {
      serverless,
      management,
      security
    } = setupDeps;
    const navigationTree$ = (((_setupDeps$streams = setupDeps.streams) === null || _setupDeps$streams === void 0 ? void 0 : _setupDeps$streams.navigationStatus$) || (0, _rxjs.of)({
      status: 'disabled'
    })).pipe((0, _rxjs.map)(({
      status
    }) => {
      return (0, _navigation_tree.createNavigationTree)({
        streamsAvailable: status === 'enabled',
        overviewAvailable: core.pricing.isFeatureAvailable('observability:complete_overview'),
        isCasesAvailable: Boolean(setupDeps.cases)
      });
    }));
    serverless.setProjectHome('/app/observability/landing');
    serverless.initNavigation('oblt', navigationTree$, {
      dataTestSubj: 'svlObservabilitySideNav'
    });
    const aiAssistantIsEnabled = (_core$application$cap = core.application.capabilities.observabilityAIAssistant) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show;
    const extendCardNavDefinitions = serverless.getNavigationCards(security.authz.isRoleManagementEnabled(), aiAssistantIsEnabled ? {
      observabilityAiAssistantManagement: {
        category: _managementCardsNavigation.appCategories.OTHER,
        title: _i18n.i18n.translate('xpack.serverlessObservability.aiAssistantManagementTitle', {
          defaultMessage: 'AI Assistant Settings'
        }),
        description: _i18n.i18n.translate('xpack.serverlessObservability.aiAssistantManagementDescription', {
          defaultMessage: 'Manage knowledge base and control assistant behavior, including response language.'
        }),
        icon: 'sparkles'
      }
    } : undefined);
    management.setupCardsNavigation({
      enabled: true,
      hideLinksTo: [_managementCardsNavigation.appIds.RULES],
      extendCardNavDefinitions
    });
    return {};
  }
  stop() {}
}
exports.ServerlessObservabilityPlugin = ServerlessObservabilityPlugin;