"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServerListener = getServerListener;
var _http = _interopRequireDefault(require("http"));
var _https = _interopRequireDefault(require("https"));
var _http2 = _interopRequireDefault(require("http2"));
var _get_tls_options = require("./get_tls_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getServerListener(config, options = {}) {
  const useHTTP2 = config.protocol === 'http2';
  return useHTTP2 ? configureHttp2Listener(config, options) : configureHttp1Listener(config, options);
}
const configureHttp1Listener = (config, {
  configureTLS = true
} = {}) => {
  const useTLS = configureTLS && config.ssl.enabled;
  const tlsOptions = useTLS ? (0, _get_tls_options.getServerTLSOptions)(config.ssl) : undefined;
  const listener = useTLS ? _https.default.createServer({
    ...tlsOptions,
    keepAliveTimeout: config.keepaliveTimeout
  }) : _http.default.createServer({
    keepAliveTimeout: config.keepaliveTimeout
  });
  listener.setTimeout(config.socketTimeout);
  listener.on('timeout', socket => {
    socket.destroy();
  });
  listener.on('clientError', (err, socket) => {
    if (socket.writable) {
      socket.end(Buffer.from('HTTP/1.1 400 Bad Request\r\n\r\n', 'ascii'));
    } else {
      socket.destroy(err);
    }
  });
  return listener;
};
const configureHttp2Listener = (config, {
  configureTLS = true
} = {}) => {
  const useTLS = configureTLS && config.ssl.enabled;
  const tlsOptions = useTLS ? (0, _get_tls_options.getServerTLSOptions)(config.ssl) : undefined;
  const listener = useTLS ? _http2.default.createSecureServer({
    ...tlsOptions,
    // allow ALPN negotiation fallback to HTTP/1.x
    allowHTTP1: true
  }) : _http2.default.createServer({});
  listener.setTimeout(config.socketTimeout);
  return listener;
};