"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matchesOperator = exports.isOperator = exports.isOneOfOperator = exports.isNotOperator = exports.isNotOneOfOperator = exports.isNotInListOperator = exports.isInListOperator = exports.existsOperator = exports.doesNotMatchOperator = exports.doesNotExistOperator = exports.EXCEPTION_OPERATORS_SANS_LISTS = exports.EXCEPTION_OPERATORS_ONLY_LISTS = exports.ENDPOINT_ARTIFACT_OPERATORS = exports.DETECTION_ENGINE_EXCEPTION_OPERATORS = exports.ALL_OPERATORS_SANS_MATCHES = exports.ALL_OPERATORS = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isOperator = exports.isOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isOperatorLabel', {
    defaultMessage: 'is'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH,
  value: 'is'
};
const isNotOperator = exports.isNotOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isNotOperatorLabel', {
    defaultMessage: 'is not'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH,
  value: 'is_not'
};
const isOneOfOperator = exports.isOneOfOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isOneOfOperatorLabel', {
    defaultMessage: 'is one of'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY,
  value: 'is_one_of'
};
const isNotOneOfOperator = exports.isNotOneOfOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isNotOneOfOperatorLabel', {
    defaultMessage: 'is not one of'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY,
  value: 'is_not_one_of'
};
const existsOperator = exports.existsOperator = {
  message: _i18n.i18n.translate('lists.exceptions.existsOperatorLabel', {
    defaultMessage: 'exists'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS,
  value: 'exists'
};
const doesNotExistOperator = exports.doesNotExistOperator = {
  message: _i18n.i18n.translate('lists.exceptions.doesNotExistOperatorLabel', {
    defaultMessage: 'does not exist'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS,
  value: 'does_not_exist'
};
const isInListOperator = exports.isInListOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isInListOperatorLabel', {
    defaultMessage: 'is in list'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST,
  value: 'is_in_list'
};
const isNotInListOperator = exports.isNotInListOperator = {
  message: _i18n.i18n.translate('lists.exceptions.isNotInListOperatorLabel', {
    defaultMessage: 'is not in list'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST,
  value: 'is_not_in_list'
};
const matchesOperator = exports.matchesOperator = {
  message: _i18n.i18n.translate('lists.exceptions.matchesOperatorLabel', {
    defaultMessage: 'matches'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD,
  value: 'matches'
};
const doesNotMatchOperator = exports.doesNotMatchOperator = {
  message: _i18n.i18n.translate('lists.exceptions.doesNotMatchOperatorLabel', {
    defaultMessage: 'does not match'
  }),
  operator: _securitysolutionIoTsListTypes.ListOperatorEnum.EXCLUDED,
  type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD,
  value: 'does_not_match'
};

/**
 * Operators valid for event filters, trusted apps and endpoint exceptions
 */
const ENDPOINT_ARTIFACT_OPERATORS = exports.ENDPOINT_ARTIFACT_OPERATORS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, matchesOperator, doesNotMatchOperator];

/*
 * !IMPORTANT! - Please only add to this list if it is an operator
 * supported by the detection engine.
 */
const DETECTION_ENGINE_EXCEPTION_OPERATORS = exports.DETECTION_ENGINE_EXCEPTION_OPERATORS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, existsOperator, doesNotExistOperator, isInListOperator, isNotInListOperator, matchesOperator, doesNotMatchOperator];
const ALL_OPERATORS = exports.ALL_OPERATORS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, existsOperator, doesNotExistOperator, isInListOperator, isNotInListOperator, matchesOperator, doesNotMatchOperator];
const ALL_OPERATORS_SANS_MATCHES = exports.ALL_OPERATORS_SANS_MATCHES = ALL_OPERATORS.filter(operator => operator !== matchesOperator && operator !== doesNotMatchOperator);
const EXCEPTION_OPERATORS_SANS_LISTS = exports.EXCEPTION_OPERATORS_SANS_LISTS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, existsOperator, doesNotExistOperator, matchesOperator, doesNotMatchOperator];
const EXCEPTION_OPERATORS_ONLY_LISTS = exports.EXCEPTION_OPERATORS_ONLY_LISTS = [isInListOperator, isNotInListOperator];