"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexAliases = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Retrieves all index aliases for a given alias name
 *
 * @param esClient An {@link ElasticsearchClient}
 * @param alias alias name used to filter results
 * @param index index name used to filter results
 *
 * @returns an array of {@link IndexAlias} objects
 */
const getIndexAliases = async ({
  esClient,
  alias,
  index
}) => {
  const response = await esClient.indices.getAlias({
    name: alias,
    ...(index ? {
      index
    } : {})
  }, {
    meta: true
  });
  return Object.keys(response.body).map(indexName => {
    var _response$body$indexN;
    return {
      alias,
      index: indexName,
      isWriteIndex: ((_response$body$indexN = response.body[indexName].aliases[alias]) === null || _response$body$indexN === void 0 ? void 0 : _response$body$indexN.is_write_index) === true
    };
  });
};
exports.getIndexAliases = getIndexAliases;