"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateSchemaByVersion = exports.emptyState = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * WARNING: Do not modify the existing versioned schema(s) below, instead define a new version (ex: 2, 3, 4).
 * This is required to support zero-downtime upgrades and rollbacks. See https://github.com/elastic/kibana/issues/155764.
 *
 * As you add a new schema version, don't forget to change latestTaskStateSchema variable to reference the latest schema.
 * For example, changing stateSchemaByVersion[1].schema to stateSchemaByVersion[2].schema.
 */
const stateSchemaByVersion = exports.stateSchemaByVersion = {
  1: {
    // A task that was created < 8.10 will go through this "up" migration
    // to ensure it matches the v1 schema.
    up: state => ({
      lastSuccessfulReport: state.lastSuccessfulReport || null
    }),
    schema: _configSchema.schema.object({
      lastSuccessfulReport: _configSchema.schema.nullable(_configSchema.schema.string())
    })
  },
  2: {
    // A task that was created < 9.0 will go through this "up" migration
    // to ensure it matches the v2 schema.
    up: state => ({
      lastSuccessfulReport: state.lastSuccessfulReport || null,
      backfillRecords: state.backfillRecords || []
    }),
    schema: _configSchema.schema.object({
      lastSuccessfulReport: _configSchema.schema.nullable(_configSchema.schema.string()),
      backfillRecords: _configSchema.schema.arrayOf(_configSchema.schema.object({
        id: _configSchema.schema.string(),
        usage_timestamp: _configSchema.schema.string(),
        creation_timestamp: _configSchema.schema.string(),
        usage: _configSchema.schema.object({
          type: _configSchema.schema.string(),
          sub_type: _configSchema.schema.maybe(_configSchema.schema.string()),
          quantity: _configSchema.schema.number(),
          period_seconds: _configSchema.schema.maybe(_configSchema.schema.number()),
          cause: _configSchema.schema.maybe(_configSchema.schema.string()),
          metadata: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string()))
        }),
        source: _configSchema.schema.object({
          id: _configSchema.schema.string(),
          instance_group_id: _configSchema.schema.string(),
          metadata: _configSchema.schema.maybe(_configSchema.schema.object({
            tier: _configSchema.schema.maybe(_configSchema.schema.string())
          }))
        })
      }))
    })
  }
};
const latestTaskStateSchema = stateSchemaByVersion[2].schema;
const emptyState = exports.emptyState = {
  lastSuccessfulReport: null,
  backfillRecords: []
};