"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startNavigation = void 0;
var _common = require("@kbn/security-solution-plugin/common");
var _breadcrumbs = require("./breadcrumbs");
var _navigation = require("./navigation");
var _management_cards = require("./management_cards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startNavigation = (services, productTypes) => {
  services.serverless.setProjectHome(_common.APP_PATH);
  (0, _navigation.registerSolutionNavigation)(services, productTypes);
  (0, _management_cards.enableManagementCardsLanding)(services);
  (0, _breadcrumbs.subscribeBreadcrumbs)(services);
};
exports.startNavigation = startNavigation;