"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOLUTION_NAME = exports.CONFIGURATIONS = exports.CALLOUT_TITLE = exports.CALLOUT_DESCRIPTION = exports.CALLOUT_ARIA_LABEL = exports.ALERT_SUMMARY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOLUTION_NAME = exports.SOLUTION_NAME = _i18n.i18n.translate('xpack.securitySolutionServerless.socNavLinks.projectType.title', {
  defaultMessage: 'Elastic AI SOC Engine'
});
const ALERT_SUMMARY = exports.ALERT_SUMMARY = _i18n.i18n.translate('xpack.securitySolutionServerless.navigation.aiSoc.alertSummary', {
  defaultMessage: 'Alert summary'
});
const CONFIGURATIONS = exports.CONFIGURATIONS = _i18n.i18n.translate('xpack.securitySolutionServerless.navigation.aiSoc.configurations', {
  defaultMessage: 'Configurations'
});
const CALLOUT_TITLE = exports.CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolutionServerless.navigation.aiSoc.callout.title', {
  defaultMessage: 'Powered by Elastic AI'
});
const CALLOUT_DESCRIPTION = exports.CALLOUT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolutionServerless.navigation.aiSoc.callout.description', {
  defaultMessage: 'Empowering SOCs for faster threat detection, investigation, and response'
});
const CALLOUT_ARIA_LABEL = exports.CALLOUT_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolutionServerless.navigation.aiSoc.callout.ariaLabel', {
  defaultMessage: 'Information about Elastic AI SOC Engine'
});