"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createServices = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates the services for the plugin components to consume.
 * It should be created only once and stored in the ServicesProvider for general access
 * */
const createServices = (core, pluginsStart, experimentalFeatures) => {
  return {
    ...core,
    ...pluginsStart,
    experimentalFeatures
  };
};
exports.createServices = createServices;