"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorStatusCode = exports.getErrorMessage = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extracts error message from an error
 *
 * @param error Unknown error
 * @returns error message
 */
const getErrorMessage = error => {
  if (error instanceof Error) {
    return error.message;
  } else if (typeof error === 'string') {
    return error;
  } else {
    return 'Unknown error';
  }
};
exports.getErrorMessage = getErrorMessage;
const hasStatusCode = error => typeof error === 'object' && error !== null && 'statusCode' in error;

/**
 * Extracts status code from an error
 *
 * @param error Unknown error
 * @returns Stats code if it exists
 */
const getErrorStatusCode = error => {
  if (hasStatusCode(error)) {
    return Number(error.statusCode);
  }
  return undefined;
};
exports.getErrorStatusCode = getErrorStatusCode;