"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildManagedUserDetailsQuery = void 0;
var _managed_details = require("../../../../../../common/search_strategy/security_solution/users/managed_details");
var _search_strategy = require("../../../../../../common/search_strategy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildManagedUserDetailsQuery = ({
  userEmail,
  userName,
  defaultIndex
}) => {
  const should = [{
    term: {
      'user.name': userName
    }
  }];
  if (userEmail) {
    const emailQuery = {
      terms: {
        'user.email': userEmail
      }
    };
    should.push(emailQuery);
  }
  const filter = [{
    terms: {
      'event.dataset': [_managed_details.ManagedUserDatasetKey.OKTA, _managed_details.ManagedUserDatasetKey.ENTRA]
    }
  }, _search_strategy.EVENT_KIND_ASSET_FILTER];
  const dslQuery = {
    allow_no_indices: true,
    index: defaultIndex,
    ignore_unavailable: true,
    track_total_hits: false,
    query: {
      bool: {
        filter,
        should,
        minimum_should_match: 1
      }
    },
    size: 0,
    aggs: {
      datasets: {
        terms: {
          field: 'event.dataset'
        },
        aggs: {
          latest_hit: {
            top_hits: {
              fields: ['*', '_index', '_id'],
              // '_index' and '_id' are not returned by default
              _source: false,
              size: 1,
              sort: [{
                '@timestamp': {
                  order: 'desc'
                }
              }]
            }
          }
        }
      }
    },
    sort: [{
      '@timestamp': 'desc'
    }]
  };
  return dslQuery;
};
exports.buildManagedUserDetailsQuery = buildManagedUserDetailsQuery;