"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.managedUserDetails = void 0;
var _fp = require("lodash/fp");
var _build_query = require("../../../../../utils/build_query");
var _queryManaged_user_details = require("./query.managed_user_details.dsl");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const managedUserDetails = exports.managedUserDetails = {
  buildDsl: options => (0, _queryManaged_user_details.buildManagedUserDetailsQuery)(options),
  parse: async (options, response) => {
    const inspect = {
      dsl: [(0, _build_query.inspectStringifyObject)((0, _queryManaged_user_details.buildManagedUserDetailsQuery)(options))]
    };
    const buckets = (0, _fp.getOr)([], 'aggregations.datasets.buckets', response.rawResponse);
    const managedUsers = buckets.reduce((acc, bucket) => {
      acc[bucket.key] = bucket.latest_hit.hits.hits[0];
      return acc;
    }, {});
    return {
      ...response,
      inspect,
      users: managedUsers
    };
  }
};