"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatServiceItem = exports.fieldNameToAggField = exports.SERVICE_FIELDS = void 0;
var _fp = require("@kbn/safer-lodash-set/fp");
var _fp2 = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SERVICE_FIELDS = exports.SERVICE_FIELDS = ['service.id', 'service.name', 'service.address', 'service.environment', 'service.ephemeral_id', 'service.node.name', 'service.node.roles', 'service.node.role', 'service.state', 'service.type', 'service.version'];
const fieldNameToAggField = fieldName => fieldName.replace(/\./g, '_');
exports.fieldNameToAggField = fieldNameToAggField;
const formatServiceItem = aggregations => {
  return SERVICE_FIELDS.reduce((flattenedFields, fieldName) => {
    const aggField = fieldNameToAggField(fieldName);
    if ((0, _fp2.has)(aggField, aggregations)) {
      const data = (0, _fp2.get)(aggField, aggregations);
      const fieldValue = data.buckets.map(obj => obj.key);
      return (0, _fp.set)(fieldName, fieldValue, flattenedFields);
    }
    return flattenedFields;
  }, {});
};
exports.formatServiceItem = formatServiceItem;