"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CachedSubject = void 0;
exports.retryOnError$ = retryOnError$;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var rx = _interopRequireWildcard(require("rxjs"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This utility class stores the values sent to a reactive flow while its state
 * is `started`. Once it's stopped (after calling `flush()`) it will send all
 * the cached values to the configured `subject$`.
 */
class CachedSubject {
  constructor(subject$) {
    (0, _defineProperty2.default)(this, "flushCache$", new rx.Subject());
    (0, _defineProperty2.default)(this, "stopCaching$", new rx.Subject());
    this.setup(subject$);
  }
  stop() {
    this.stopCaching$.next();
  }
  flush() {
    this.flushCache$.next();
  }
  setup(subject$) {
    // Cache the incoming events that are sent during the timeframe between
    // `service.setup()` and `service.start()`, otherwise, they would be lost
    const cache$ = new rx.ReplaySubject();
    const storingCache$ = new rx.BehaviorSubject(true);

    // 1. sends incoming values to the cache$, works only while
    // `storingCache$` is set to true
    storingCache$.pipe(rx.distinctUntilChanged(), rx.switchMap(isCaching => isCaching ? subject$ : rx.EMPTY), rx.takeUntil(rx.merge(this.stopCaching$))).subscribe(data => {
      cache$.next(data);
    });

    // 2. when flushCache is triggered, stop caching values and send the cached
    // ones to the real flow (i.e. `subject$`).
    this.flushCache$.pipe(rx.exhaustMap(() => cache$)).subscribe(data => {
      storingCache$.next(false);
      subject$.next(data);
    });
  }
}

/**
 * Executes the given `body()` function wrappig it in a retry logic by using
 * the rxjs `retry` operator.
 *
 * @param retryCount the number of times to retry the `body()` function
 * @param retryDelayMillis the delay between each retry
 * @param body the function to execute
 * @returns an observable that emits either the result returned by the `body()`
 * function or the latest caught error after exhausting the retryCount.
 */
exports.CachedSubject = CachedSubject;
function retryOnError$(retryCount, retryDelayMillis, body) {
  return rx.defer(async () => body()).pipe(rx.retry({
    count: retryCount,
    delay: retryDelayMillis
  }), rx.catchError(error => {
    return rx.of(error);
  }));
}